/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.EOFException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.Base85;

public class BinaryHunkInputStream
extends InputStream {
    private final InputStream in;
    private int lineNumber;
    private byte[] buffer;
    private int pos = 0;

    public BinaryHunkInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int read() {
        if (this.pos < 0) {
            return -1;
        }
        if (this.buffer == null || this.pos == this.buffer.length) {
            this.fillBuffer();
        }
        if (this.pos >= 0) {
            return this.buffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        return super.read(byArray, n2, n3);
    }

    @Override
    public void close() {
        this.in.close();
        this.buffer = null;
    }

    private void fillBuffer() {
        int n2;
        int n3 = this.in.read();
        if (n3 < 0) {
            this.pos = n3;
            this.buffer = null;
            return;
        }
        ++this.lineNumber;
        if (65 <= n3 && n3 <= 90) {
            n3 = n3 - 65 + 1;
        } else if (97 <= n3 && n3 <= 122) {
            n3 = n3 - 97 + 27;
        } else {
            throw new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryHunkInvalidLength, this.lineNumber, Integer.toHexString(n3)));
        }
        byte[] byArray = new byte[Base85.encodedLength(n3)];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n4 = this.in.read();
            if (n4 < 0 || n4 == 10) {
                throw new EOFException(MessageFormat.format(JGitText.get().binaryHunkInvalidLength, this.lineNumber));
            }
            byArray[n2] = (byte)n4;
        }
        n2 = this.in.read();
        if (n2 >= 0 && n2 != 10) {
            throw new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryHunkMissingNewline, this.lineNumber));
        }
        try {
            this.buffer = Base85.decode(byArray, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryHunkDecodeError, this.lineNumber));
            streamCorruptedException.initCause(illegalArgumentException);
            throw streamCorruptedException;
        }
        this.pos = 0;
    }
}

