/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public class BinaryDeltaInputStream
extends InputStream {
    private final byte[] base;
    private final InputStream delta;
    private long resultLength;
    private long toDeliver = -1L;
    private int fromBase;
    private int fromDelta;
    private int baseOffset = -1;

    public BinaryDeltaInputStream(byte[] byArray, InputStream inputStream) {
        this.base = byArray;
        this.delta = inputStream;
    }

    @Override
    public int read() {
        int n2 = this.readNext();
        if (n2 >= 0) {
            --this.toDeliver;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        return super.read(byArray, n2, n3);
    }

    private void initialize() {
        long l2 = this.readVarInt(this.delta);
        if (l2 > Integer.MAX_VALUE || l2 < 0L || (int)l2 != this.base.length) {
            throw new IOException(MessageFormat.format(JGitText.get().binaryDeltaBaseLengthMismatch, this.base.length, l2));
        }
        this.resultLength = this.readVarInt(this.delta);
        if (this.resultLength < 0L) {
            throw new StreamCorruptedException(JGitText.get().binaryDeltaInvalidResultLength);
        }
        this.toDeliver = this.resultLength;
        this.baseOffset = 0;
    }

    private int readNext() {
        if (this.baseOffset < 0) {
            this.initialize();
        }
        if (this.fromBase > 0) {
            --this.fromBase;
            return this.base[this.baseOffset++] & 0xFF;
        }
        if (this.fromDelta > 0) {
            --this.fromDelta;
            return this.delta.read();
        }
        int n2 = this.delta.read();
        if (n2 < 0) {
            return -1;
        }
        if ((n2 & 0x80) != 0) {
            long l2 = 0L;
            int n3 = 1;
            int n4 = 0;
            while (n3 < 16) {
                if ((n2 & n3) != 0) {
                    l2 |= (long)this.next(this.delta) << n4;
                }
                n3 *= 2;
                n4 += 8;
            }
            n3 = 0;
            n4 = 16;
            int n5 = 0;
            while (n4 < 128) {
                if ((n2 & n4) != 0) {
                    n3 |= this.next(this.delta) << n5;
                }
                n4 *= 2;
                n5 += 8;
            }
            if (n3 == 0) {
                n3 = 65536;
            }
            if (l2 > (long)(this.base.length - n3)) {
                throw new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryDeltaInvalidOffset, l2, n3));
            }
            this.baseOffset = (int)l2;
            this.fromBase = n3;
            return this.readNext();
        }
        if (n2 != 0) {
            this.fromDelta = n2 - 1;
            return this.delta.read();
        }
        throw new StreamCorruptedException(JGitText.get().unsupportedCommand0);
    }

    private int next(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    private long readVarInt(InputStream inputStream) {
        int n2;
        long l2 = 0L;
        int n3 = 0;
        do {
            n2 = this.next(inputStream);
            l2 |= (long)(n2 & 0x7F) << n3;
            n3 += 7;
        } while ((n2 & 0x80) != 0);
        return l2;
    }

    public long getExpectedResultSize() {
        if (this.baseOffset < 0) {
            this.initialize();
        }
        return this.resultLength;
    }

    public boolean isFullyConsumed() {
        try {
            return this.toDeliver == 0L && this.delta.read() < 0;
        }
        catch (IOException iOException) {
            return this.toDeliver == 0L;
        }
    }

    @Override
    public void close() {
        this.delta.close();
    }
}

