/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.OutputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoLFOutputStream
extends OutputStream {
    static final int BUFFER_SIZE = 8000;
    private final OutputStream out;
    private int buf = -1;
    private byte[] binbuf = new byte[8000];
    private byte[] onebytebuf = new byte[1];
    private int binbufcnt = 0;
    private boolean detectBinary;
    private boolean isBinary;

    public AutoLFOutputStream(OutputStream outputStream) {
        this(outputStream, true);
    }

    public AutoLFOutputStream(OutputStream outputStream, boolean bl2) {
        this.out = outputStream;
        this.detectBinary = bl2;
    }

    @Override
    public void write(int n2) {
        this.onebytebuf[0] = (byte)n2;
        this.write(this.onebytebuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray) {
        int n2 = this.buffer(byArray, 0, byArray.length);
        if (n2 > 0) {
            this.write(byArray, byArray.length - n2, n2);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4 = this.buffer(byArray, n2, n3);
        if (n4 <= 0) {
            return;
        }
        int n5 = n2 + n3 - n4;
        int n6 = n4;
        int n7 = n5;
        if (this.isBinary) {
            this.out.write(byArray, n5, n6);
            return;
        }
        block4: for (int i2 = n5; i2 < n5 + n6; ++i2) {
            byte by = byArray[i2];
            switch (by) {
                case 13: {
                    if (n7 < i2) {
                        this.out.write(byArray, n7, i2 - n7);
                    }
                    n7 = i2 + 1;
                    this.buf = 13;
                    continue block4;
                }
                case 10: {
                    if (this.buf == 13) {
                        this.out.write(10);
                        n7 = i2 + 1;
                        this.buf = -1;
                        continue block4;
                    }
                    if (n7 < i2 + 1) {
                        this.out.write(byArray, n7, i2 + 1 - n7);
                    }
                    n7 = i2 + 1;
                    continue block4;
                }
                default: {
                    if (this.buf == 13) {
                        this.out.write(13);
                        n7 = i2;
                    }
                    this.buf = -1;
                }
            }
        }
        if (n7 < n5 + n6) {
            this.out.write(byArray, n7, n5 + n6 - n7);
        }
    }

    private int buffer(byte[] byArray, int n2, int n3) {
        if (this.binbufcnt > this.binbuf.length) {
            return n3;
        }
        int n4 = Math.min(this.binbuf.length - this.binbufcnt, n3);
        System.arraycopy(byArray, n2, this.binbuf, this.binbufcnt, n4);
        this.binbufcnt += n4;
        int n5 = n3 - n4;
        if (n5 > 0) {
            this.decideMode();
        }
        return n5;
    }

    private void decideMode() {
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.binbuf, this.binbufcnt);
            if (!this.isBinary) {
                this.isBinary = RawText.isCrLfText(this.binbuf, this.binbufcnt);
            }
            this.detectBinary = false;
        }
        int n2 = this.binbufcnt;
        this.binbufcnt = this.binbuf.length + 1;
        this.write(this.binbuf, 0, n2);
    }

    @Override
    public void flush() {
        if (this.binbufcnt <= this.binbuf.length) {
            this.decideMode();
        }
        this.out.flush();
    }

    @Override
    public void close() {
        this.flush();
        if (this.buf == 13) {
            this.out.write(this.buf);
            this.buf = -1;
        }
        this.out.close();
    }
}

