/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.util.io.AutoLFInputStream$IsBinaryException;
import org.eclipse.jgit.util.io.AutoLFInputStream$StreamFlag;

public class AutoLFInputStream
extends InputStream {
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[8192];
    private final InputStream in;
    private int cnt;
    private int ptr;
    private boolean passAsIs;
    private boolean isBinary;
    private boolean detectBinary;
    private final boolean abortIfBinary;
    private final boolean forCheckout;

    public static AutoLFInputStream create(InputStream inputStream, AutoLFInputStream$StreamFlag ... autoLFInputStream$StreamFlagArray) {
        if (autoLFInputStream$StreamFlagArray == null) {
            return new AutoLFInputStream(inputStream, null);
        }
        EnumSet<AutoLFInputStream$StreamFlag> enumSet = EnumSet.noneOf(AutoLFInputStream$StreamFlag.class);
        enumSet.addAll(Arrays.asList(autoLFInputStream$StreamFlagArray));
        return new AutoLFInputStream(inputStream, enumSet);
    }

    public AutoLFInputStream(InputStream inputStream, Set set) {
        this.in = inputStream;
        this.detectBinary = set != null && set.contains((Object)AutoLFInputStream$StreamFlag.DETECT_BINARY);
        this.abortIfBinary = set != null && set.contains((Object)AutoLFInputStream$StreamFlag.ABORT_IF_BINARY);
        this.forCheckout = set != null && set.contains((Object)AutoLFInputStream$StreamFlag.FOR_CHECKOUT);
    }

    @Deprecated
    public AutoLFInputStream(InputStream inputStream, boolean bl2) {
        this(inputStream, bl2, false);
    }

    @Deprecated
    public AutoLFInputStream(InputStream inputStream, boolean bl2, boolean bl3) {
        this.in = inputStream;
        this.detectBinary = bl2;
        this.abortIfBinary = bl3;
        this.forCheckout = false;
    }

    @Override
    public int read() {
        int n2 = this.read(this.single, 0, 1);
        return n2 == 1 ? this.single[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5 && (this.ptr != this.cnt || this.fillBuffer())) {
            byte by = this.buf[this.ptr++];
            if (this.passAsIs || by != 13) {
                byArray[n4++] = by;
                continue;
            }
            if (this.ptr == this.cnt && !this.fillBuffer()) {
                byArray[n4++] = 13;
                break;
            }
            if (this.buf[this.ptr] == 10) {
                byArray[n4++] = 10;
                ++this.ptr;
                continue;
            }
            byArray[n4++] = 13;
        }
        return n4 == n2 ? -1 : n4 - n2;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public void close() {
        this.in.close();
    }

    private boolean fillBuffer() {
        int n2;
        this.cnt = 0;
        while (this.cnt < this.buf.length && (n2 = this.in.read(this.buf, this.cnt, this.buf.length - this.cnt)) >= 0) {
            this.cnt += n2;
        }
        if (this.cnt < 1) {
            this.cnt = -1;
            return false;
        }
        if (this.detectBinary) {
            this.passAsIs = this.isBinary = RawText.isBinary(this.buf, this.cnt);
            this.detectBinary = false;
            if (this.isBinary && this.abortIfBinary) {
                throw new AutoLFInputStream$IsBinaryException();
            }
            if (!this.passAsIs && this.forCheckout) {
                this.passAsIs = RawText.isCrLfText(this.buf, this.cnt);
            }
        }
        this.ptr = 0;
        return true;
    }
}

