/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoCRLFInputStream
extends InputStream {
    static final int BUFFER_SIZE = 8096;
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[8096];
    private final InputStream in;
    private int cnt;
    private int ptr;
    private boolean isBinary;
    private boolean detectBinary;
    private byte last;

    public AutoCRLFInputStream(InputStream inputStream, boolean bl2) {
        this.in = inputStream;
        this.detectBinary = bl2;
    }

    @Override
    public int read() {
        int n2 = this.read(this.single, 0, 1);
        return n2 == 1 ? this.single[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int n5 = n2;
        int n6 = n2 + n3;
        while (n5 < n6 && (this.ptr != this.cnt || this.fillBuffer())) {
            n4 = this.buf[this.ptr++];
            if (this.isBinary || n4 != 10) {
                int n7 = n5++;
                int n8 = n4;
                this.last = (byte)n8;
                byArray[n7] = n8;
                continue;
            }
            if (n4 == 10) {
                if (this.last == 13) {
                    int n9 = n5++;
                    int n10 = n4;
                    this.last = (byte)n10;
                    byArray[n9] = n10;
                    continue;
                }
                int n11 = n5++;
                this.last = (byte)13;
                byArray[n11] = 13;
                --this.ptr;
                continue;
            }
            int n12 = n5++;
            int n13 = n4;
            this.last = (byte)n13;
            byArray[n12] = n13;
        }
        int n14 = n4 = n5 == n2 ? -1 : n5 - n2;
        if (n4 > 0) {
            this.last = byArray[n5 - 1];
        }
        return n4;
    }

    @Override
    public void close() {
        this.in.close();
    }

    private boolean fillBuffer() {
        int n2;
        this.cnt = 0;
        while (this.cnt < this.buf.length && (n2 = this.in.read(this.buf, this.cnt, this.buf.length - this.cnt)) >= 0) {
            this.cnt += n2;
        }
        if (this.cnt < 1) {
            this.cnt = -1;
            return false;
        }
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.buf, this.cnt);
            this.detectBinary = false;
        }
        this.ptr = 0;
        return true;
    }
}

