/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer$1;
import org.eclipse.jgit.util.TemporaryBuffer$Block;
import org.eclipse.jgit.util.TemporaryBuffer$BlockInputStream;

public abstract class TemporaryBuffer
extends OutputStream {
    protected static final int DEFAULT_IN_CORE_LIMIT = 0x100000;
    ArrayList blocks;
    private int inCoreLimit;
    private int initialBlocks;
    private OutputStream overflow;

    protected TemporaryBuffer(int n2) {
        this(n2, n2);
    }

    protected TemporaryBuffer(int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        this.inCoreLimit = n3;
        this.initialBlocks = (n2 - 1) / 8192 + 1;
        this.reset();
    }

    @Override
    public void write(int n2) {
        if (this.overflow != null) {
            this.overflow.write(n2);
            return;
        }
        TemporaryBuffer$Block temporaryBuffer$Block = this.last();
        if (temporaryBuffer$Block.isFull()) {
            if (this.reachedInCoreLimit()) {
                this.overflow.write(n2);
                return;
            }
            temporaryBuffer$Block = new TemporaryBuffer$Block();
            this.blocks.add(temporaryBuffer$Block);
        }
        temporaryBuffer$Block.buffer[temporaryBuffer$Block.count++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (this.overflow == null) {
            while (n3 > 0) {
                TemporaryBuffer$Block temporaryBuffer$Block = this.last();
                if (temporaryBuffer$Block.isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    temporaryBuffer$Block = new TemporaryBuffer$Block();
                    this.blocks.add(temporaryBuffer$Block);
                }
                int n4 = Math.min(temporaryBuffer$Block.buffer.length - temporaryBuffer$Block.count, n3);
                System.arraycopy(byArray, n2, temporaryBuffer$Block.buffer, temporaryBuffer$Block.count, n4);
                temporaryBuffer$Block.count += n4;
                n3 -= n4;
                n2 += n4;
            }
        }
        if (n3 > 0) {
            this.overflow.write(byArray, n2, n3);
        }
    }

    protected void doFlush() {
        if (this.overflow == null) {
            this.switchToOverflow();
        }
        this.overflow.flush();
    }

    public void copy(InputStream inputStream) {
        int n2;
        Object object;
        if (this.blocks != null) {
            while (true) {
                if (((TemporaryBuffer$Block)(object = this.last())).isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    object = new TemporaryBuffer$Block();
                    this.blocks.add(object);
                }
                if ((n2 = inputStream.read(((TemporaryBuffer$Block)object).buffer, ((TemporaryBuffer$Block)object).count, ((TemporaryBuffer$Block)object).buffer.length - ((TemporaryBuffer$Block)object).count)) < 1) {
                    return;
                }
                ((TemporaryBuffer$Block)object).count += n2;
            }
        }
        object = new byte[8192];
        while ((n2 = inputStream.read((byte[])object)) > 0) {
            this.overflow.write((byte[])object, 0, n2);
        }
    }

    public long length() {
        return this.inCoreLength();
    }

    private long inCoreLength() {
        TemporaryBuffer$Block temporaryBuffer$Block = this.last();
        return ((long)this.blocks.size() - 1L) * 8192L + (long)temporaryBuffer$Block.count;
    }

    public byte[] toByteArray() {
        long l2 = this.length();
        if (Integer.MAX_VALUE < l2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] byArray = new byte[(int)l2];
        int n2 = 0;
        for (TemporaryBuffer$Block temporaryBuffer$Block : this.blocks) {
            System.arraycopy(temporaryBuffer$Block.buffer, 0, byArray, n2, temporaryBuffer$Block.count);
            n2 += temporaryBuffer$Block.count;
        }
        return byArray;
    }

    public String toString(int n2) {
        try {
            return RawParseUtils.decode(this.toByteArray(n2));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public byte[] toByteArray(int n2) {
        long l2 = Math.min(this.length(), (long)n2);
        if (Integer.MAX_VALUE < l2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        int n3 = (int)l2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        for (TemporaryBuffer$Block temporaryBuffer$Block : this.blocks) {
            int n5 = Math.min(n3 - n4, temporaryBuffer$Block.count);
            System.arraycopy(temporaryBuffer$Block.buffer, 0, byArray, n4, n5);
            if ((n4 += n5) != n3) continue;
            break;
        }
        return byArray;
    }

    public void writeTo(OutputStream outputStream, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        for (TemporaryBuffer$Block temporaryBuffer$Block : this.blocks) {
            outputStream.write(temporaryBuffer$Block.buffer, 0, temporaryBuffer$Block.count);
            progressMonitor.update(temporaryBuffer$Block.count / 1024);
        }
    }

    public InputStream openInputStream() {
        return new TemporaryBuffer$BlockInputStream(this);
    }

    public InputStream openInputStreamWithAutoDestroy() {
        return new TemporaryBuffer$1(this);
    }

    public void reset() {
        if (this.overflow != null) {
            this.destroy();
        }
        if (this.blocks != null) {
            this.blocks.clear();
        } else {
            this.blocks = new ArrayList(this.initialBlocks);
        }
        this.blocks.add(new TemporaryBuffer$Block(Math.min(this.inCoreLimit, 8192)));
    }

    protected abstract OutputStream overflow();

    private TemporaryBuffer$Block last() {
        return (TemporaryBuffer$Block)this.blocks.get(this.blocks.size() - 1);
    }

    private boolean reachedInCoreLimit() {
        if (this.inCoreLength() < (long)this.inCoreLimit) {
            return false;
        }
        this.switchToOverflow();
        return true;
    }

    private void switchToOverflow() {
        this.overflow = this.overflow();
        TemporaryBuffer$Block temporaryBuffer$Block = (TemporaryBuffer$Block)this.blocks.remove(this.blocks.size() - 1);
        for (TemporaryBuffer$Block temporaryBuffer$Block2 : this.blocks) {
            this.overflow.write(temporaryBuffer$Block2.buffer, 0, temporaryBuffer$Block2.count);
        }
        this.blocks = null;
        this.overflow = new BufferedOutputStream(this.overflow, 8192);
        this.overflow.write(temporaryBuffer$Block.buffer, 0, temporaryBuffer$Block.count);
    }

    @Override
    public void close() {
        if (this.overflow != null) {
            try {
                this.overflow.close();
            }
            finally {
                this.overflow = null;
            }
        }
    }

    public void destroy() {
        this.blocks = null;
        if (this.overflow != null) {
            try {
                this.overflow.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.overflow = null;
            }
        }
    }
}

