/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.TemporaryBuffer$LocalFile$1;

public class TemporaryBuffer$LocalFile
extends TemporaryBuffer {
    private final File directory;
    private File onDiskFile;

    public TemporaryBuffer$LocalFile(File file) {
        this(file, 0x100000);
    }

    public TemporaryBuffer$LocalFile(File file, int n2) {
        super(n2);
        this.directory = file;
    }

    @Override
    protected OutputStream overflow() {
        this.onDiskFile = File.createTempFile("jgit_", ".buf", this.directory);
        return new BufferedOutputStream(new FileOutputStream(this.onDiskFile));
    }

    @Override
    public long length() {
        if (this.onDiskFile == null) {
            return super.length();
        }
        return this.onDiskFile.length();
    }

    @Override
    public byte[] toByteArray() {
        if (this.onDiskFile == null) {
            return super.toByteArray();
        }
        long l2 = this.length();
        if (Integer.MAX_VALUE < l2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] byArray = new byte[(int)l2];
        try (FileInputStream fileInputStream = new FileInputStream(this.onDiskFile);){
            IO.readFully(fileInputStream, byArray, 0, (int)l2);
        }
        return byArray;
    }

    @Override
    public byte[] toByteArray(int n2) {
        if (this.onDiskFile == null) {
            return super.toByteArray(n2);
        }
        long l2 = Math.min(this.length(), (long)n2);
        if (Integer.MAX_VALUE < l2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] byArray = new byte[(int)l2];
        try (FileInputStream fileInputStream = new FileInputStream(this.onDiskFile);){
            int n3;
            int n4 = 0;
            while ((n3 = fileInputStream.read(byArray, n4, byArray.length - n4)) >= 0 && (n4 += n3) != byArray.length) {
            }
        }
        return byArray;
    }

    @Override
    public void writeTo(OutputStream outputStream, ProgressMonitor progressMonitor) {
        if (this.onDiskFile == null) {
            super.writeTo(outputStream, progressMonitor);
            return;
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try (FileInputStream fileInputStream = new FileInputStream(this.onDiskFile);){
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = fileInputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                progressMonitor.update(n2 / 1024);
            }
        }
    }

    @Override
    public InputStream openInputStream() {
        if (this.onDiskFile == null) {
            return super.openInputStream();
        }
        return new FileInputStream(this.onDiskFile);
    }

    @Override
    public InputStream openInputStreamWithAutoDestroy() {
        if (this.onDiskFile == null) {
            return super.openInputStreamWithAutoDestroy();
        }
        return new TemporaryBuffer$LocalFile$1(this, this.onDiskFile);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.onDiskFile != null) {
            try {
                if (!this.onDiskFile.delete()) {
                    this.onDiskFile.deleteOnExit();
                }
            }
            finally {
                this.onDiskFile = null;
            }
        }
    }
}

