/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader$Default;
import org.eclipse.jgit.util.time.MonotonicClock;
import org.eclipse.jgit.util.time.MonotonicSystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemReader {
    private static final Logger LOG = LoggerFactory.getLogger(SystemReader.class);
    private static final SystemReader DEFAULT;
    private static volatile Boolean isMacOS;
    private static volatile Boolean isWindows;
    private static volatile SystemReader INSTANCE;
    private ObjectChecker platformChecker;
    private AtomicReference systemConfig = new AtomicReference();
    private AtomicReference userConfig = new AtomicReference();
    private AtomicReference jgitConfig = new AtomicReference();

    public static SystemReader getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SystemReader systemReader) {
        isMacOS = null;
        isWindows = null;
        if (systemReader == null) {
            INSTANCE = DEFAULT;
        } else {
            systemReader.init();
            INSTANCE = systemReader;
        }
    }

    private void init() {
        if (this.platformChecker == null) {
            this.setPlatformChecker();
        }
    }

    protected final void setPlatformChecker() {
        this.platformChecker = new ObjectChecker().setSafeForWindows(this.isWindows()).setSafeForMacOS(this.isMacOS());
    }

    public abstract String getHostname();

    public abstract String getenv(String var1);

    public abstract String getProperty(String var1);

    public abstract FileBasedConfig openUserConfig(Config var1, FS var2);

    public abstract FileBasedConfig openSystemConfig(Config var1, FS var2);

    public abstract FileBasedConfig openSuperConfig(Config var1, FS var2);

    public abstract FileBasedConfig openJGitConfig(Config var1, FS var2);

    public StoredConfig getUserConfig() {
        return this.getUserConfig(FS.DETECTED);
    }

    public StoredConfig getUserConfig(FS fS) {
        FileBasedConfig fileBasedConfig = (FileBasedConfig)this.userConfig.get();
        if (fileBasedConfig == null) {
            this.userConfig.compareAndSet(null, this.openUserConfig(this.getSystemConfig(fS), fS));
            fileBasedConfig = (FileBasedConfig)this.userConfig.get();
        }
        this.updateAll(fileBasedConfig);
        return fileBasedConfig;
    }

    public StoredConfig getJGitConfig(FS fS) {
        FileBasedConfig fileBasedConfig = (FileBasedConfig)this.jgitConfig.get();
        if (fileBasedConfig == null) {
            this.jgitConfig.compareAndSet(null, this.openJGitConfig(null, fS));
            fileBasedConfig = (FileBasedConfig)this.jgitConfig.get();
        }
        this.updateAll(fileBasedConfig);
        return fileBasedConfig;
    }

    public StoredConfig getSystemConfig(FS fS) {
        FileBasedConfig fileBasedConfig = (FileBasedConfig)this.systemConfig.get();
        if (fileBasedConfig == null || fileBasedConfig.getFs() != fS) {
            FileBasedConfig fileBasedConfig2 = this.openSuperConfig(null, fS);
            fileBasedConfig2.load();
            FileBasedConfig fileBasedConfig3 = this.openJGitConfig(fileBasedConfig2, fS);
            ((StoredConfig)fileBasedConfig3).load();
            this.systemConfig.compareAndSet(fileBasedConfig, this.openSystemConfig(fileBasedConfig3, fS));
            fileBasedConfig = (FileBasedConfig)this.systemConfig.get();
        }
        this.updateAll(fileBasedConfig);
        return fileBasedConfig;
    }

    private void updateAll(Config config) {
        FileBasedConfig fileBasedConfig;
        if (config == null) {
            return;
        }
        this.updateAll(config.getBaseConfig());
        if (config instanceof FileBasedConfig && (fileBasedConfig = (FileBasedConfig)config).isOutdated()) {
            LOG.debug("loading config {}", (Object)fileBasedConfig);
            fileBasedConfig.load();
        }
    }

    public abstract long getCurrentTime();

    public MonotonicClock getClock() {
        return new MonotonicSystemClock();
    }

    public abstract int getTimezone(long var1);

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public SimpleDateFormat getSimpleDateFormat(String string) {
        return new SimpleDateFormat(string);
    }

    public SimpleDateFormat getSimpleDateFormat(String string, Locale locale) {
        return new SimpleDateFormat(string, locale);
    }

    public DateFormat getDateTimeInstance(int n2, int n3) {
        return DateFormat.getDateTimeInstance(n2, n3);
    }

    public boolean isWindows() {
        if (isWindows == null) {
            String string = this.getOsName();
            isWindows = string.startsWith("Windows");
        }
        return isWindows;
    }

    public boolean isMacOS() {
        if (isMacOS == null) {
            String string = this.getOsName();
            isMacOS = "Mac OS X".equals(string) || "Darwin".equals(string);
        }
        return isMacOS;
    }

    private String getOsName() {
        return AccessController.doPrivileged(() -> this.getProperty("os.name"));
    }

    public void checkPath(String string) {
        this.platformChecker.checkPath(string);
    }

    public void checkPath(byte[] byArray) {
        this.platformChecker.checkPath(byArray, 0, byArray.length);
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static {
        SystemReader$Default systemReader$Default = new SystemReader$Default();
        super.init();
        INSTANCE = DEFAULT = systemReader$Default;
    }
}

