/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.SystemReader$Default$1;
import org.eclipse.jgit.util.SystemReader$Default$2;
import org.eclipse.jgit.util.SystemReader$DummyConfig;

class SystemReader$Default
extends SystemReader {
    private volatile String hostname;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SystemReader$Default() {
    }

    @Override
    public String getenv(String string) {
        return System.getenv(string);
    }

    @Override
    public String getProperty(String string) {
        return System.getProperty(string);
    }

    @Override
    public FileBasedConfig openSuperConfig(Config config, FS fS) {
        if (!(fS instanceof FS_Win32)) {
            return new SystemReader$DummyConfig();
        }
        String string = System.getenv("ALLUSERSPROFILE");
        if (string == null) {
            return new SystemReader$DummyConfig();
        }
        File file = new File(string, "Git/config");
        return new SystemReader$Default$1(this, file, fS);
    }

    @Override
    public FileBasedConfig openSystemConfig(Config config, FS fS) {
        File file;
        if (StringUtils.isEmptyOrNull(this.getenv("GIT_CONFIG_NOSYSTEM")) && (file = fS.getGitSystemConfig()) != null) {
            return new FileBasedConfig(config, file, fS);
        }
        return new SystemReader$Default$2(this, config, null, fS);
    }

    @Override
    public FileBasedConfig openUserConfig(Config config, FS fS) {
        File file;
        Path path;
        File file2 = fS.userHome();
        File file3 = new File(file2, ".gitconfig");
        String string = System.getProperty("os.name");
        String string2 = string = string != null ? string.toLowerCase() : "";
        if (!string.contains("mac os") && !string.contains("windows") && (path = this.getXDGConfigHome(fS)) != null && (file = new File(path.toFile(), "git/config")).isFile()) {
            FileBasedConfig fileBasedConfig = new FileBasedConfig(config, file, fS);
            return file3.isFile() ? new FileBasedConfig(fileBasedConfig, file3, fS) : fileBasedConfig;
        }
        return new FileBasedConfig(config, file3, fS);
    }

    private Path getXDGConfigHome(FS fS) {
        String string = this.getenv("XDG_CONFIG_HOME");
        if (StringUtils.isEmptyOrNull(string)) {
            string = new File(fS.userHome(), ".config").getAbsolutePath();
        }
        try {
            return Paths.get(string, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            SystemReader.access$100().error(JGitText.get().logXDGConfigHomeInvalid, (Object)string, (Object)invalidPathException);
            return null;
        }
    }

    @Override
    public FileBasedConfig openJGitConfig(Config config, FS fS) {
        Path path = this.getXDGConfigHome(fS);
        if (path != null) {
            Path path2 = path.resolve("jgit").resolve("config");
            return new FileBasedConfig(config, path2.toFile(), fS);
        }
        return new FileBasedConfig(config, new File(fS.userHome(), ".jgitconfig"), fS);
    }

    @Override
    public String getHostname() {
        if (this.hostname == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.hostname = inetAddress.getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostname = "localhost";
            }
            if (!$assertionsDisabled && this.hostname == null) {
                throw new AssertionError();
            }
        }
        return this.hostname;
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public int getTimezone(long l2) {
        return this.getTimeZone().getOffset(l2) / 60000;
    }

    static {
        $assertionsDisabled = !SystemReader.class.desiredAssertionStatus();
    }
}

