/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.References;

public final class StringUtils {
    private static final char[] LC;

    public static char toLowerCase(char c2) {
        return c2 <= 'Z' ? LC[c2] : c2;
    }

    public static String toLowerCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            stringBuilder.append(StringUtils.toLowerCase(string.charAt(i2)));
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        return new StringBuilder(n2).append(Character.toTitleCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (References.isSameObject(string, string2)) {
            return true;
        }
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (StringUtils.toLowerCase(string.charAt(i2)) == StringUtils.toLowerCase(string2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static int compareIgnoreCase(String string, String string2) {
        for (int i2 = 0; i2 < string.length() && i2 < string2.length(); ++i2) {
            int n2 = StringUtils.toLowerCase(string.charAt(i2)) - StringUtils.toLowerCase(string2.charAt(i2));
            if (n2 == 0) continue;
            return n2;
        }
        return string.length() - string2.length();
    }

    public static int compareWithCase(String string, String string2) {
        for (int i2 = 0; i2 < string.length() && i2 < string2.length(); ++i2) {
            int n2 = string.charAt(i2) - string2.charAt(i2);
            if (n2 == 0) continue;
            return n2;
        }
        return string.length() - string2.length();
    }

    public static boolean toBoolean(String string) {
        if (string == null) {
            throw new NullPointerException(JGitText.get().expectedBooleanStringValue);
        }
        Boolean bl2 = StringUtils.toBooleanOrNull(string);
        if (bl2 == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notABoolean, string));
        }
        return bl2;
    }

    public static Boolean toBooleanOrNull(String string) {
        if (string == null) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase("yes", string) || StringUtils.equalsIgnoreCase("true", string) || StringUtils.equalsIgnoreCase("1", string) || StringUtils.equalsIgnoreCase("on", string)) {
            return Boolean.TRUE;
        }
        if (StringUtils.equalsIgnoreCase("no", string) || StringUtils.equalsIgnoreCase("false", string) || StringUtils.equalsIgnoreCase("0", string) || StringUtils.equalsIgnoreCase("off", string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String join(Collection collection, String string) {
        return StringUtils.join(collection, string, string);
    }

    public static String join(Collection collection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = collection.size() - 1;
        for (String string3 : collection) {
            stringBuilder.append(string3);
            if (n2 == n3 - 1) {
                stringBuilder.append(string2);
            } else if (n2 != n3) {
                stringBuilder.append(string);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private StringUtils() {
    }

    public static boolean isEmptyOrNull(String string) {
        return string == null || string.length() == 0;
    }

    public static String replaceLineBreaksWithSpace(String string) {
        char[] cArray = new char[string.length()];
        int n2 = 0;
        block4: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\r': {
                    if (i2 + 1 < cArray.length && string.charAt(i2 + 1) == '\n') {
                        cArray[n2++] = 32;
                        ++i2;
                        continue block4;
                    }
                    cArray[n2++] = 32;
                    continue block4;
                }
                case '\n': {
                    cArray[n2++] = 32;
                    continue block4;
                }
                default: {
                    cArray[n2++] = c2;
                }
            }
        }
        return new String(cArray, 0, n2);
    }

    static {
        int n2;
        LC = new char[91];
        for (n2 = 0; n2 < LC.length; n2 = (int)((char)(n2 + 1))) {
            StringUtils.LC[n2] = n2;
        }
        for (n2 = 65; n2 <= 90; n2 = (int)((char)(n2 + 1))) {
            StringUtils.LC[n2] = (char)(97 + (n2 - 65));
        }
    }
}

