/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

public class SshSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runSshCommand(URIish uRIish, @Nullable CredentialsProvider credentialsProvider, FS fS, String string, int n2) {
        String string2;
        MessageWriter messageWriter;
        MessageWriter messageWriter2;
        CommandFailedException commandFailedException;
        StreamCopyThread streamCopyThread;
        Process process;
        RemoteSession remoteSession;
        block42: {
            remoteSession = null;
            process = null;
            StreamCopyThread streamCopyThread2 = null;
            streamCopyThread = null;
            commandFailedException = null;
            messageWriter2 = new MessageWriter();
            messageWriter = new MessageWriter();
            try {
                long l2 = System.nanoTime();
                remoteSession = SshSessionFactory.getInstance().getSession(uRIish, credentialsProvider, fS, 1000 * n2);
                int n3 = n2;
                if (n2 > 0) {
                    n3 = SshSupport.checkTimeout(string, n2, l2);
                }
                process = remoteSession.exec(string, n3);
                if (n2 > 0) {
                    n3 = SshSupport.checkTimeout(string, n2, l2);
                }
                streamCopyThread2 = new StreamCopyThread(process.getErrorStream(), messageWriter2.getRawStream());
                streamCopyThread2.start();
                streamCopyThread = new StreamCopyThread(process.getInputStream(), messageWriter.getRawStream());
                streamCopyThread.start();
                try {
                    boolean bl2 = false;
                    if (n2 <= 0) {
                        process.waitFor();
                        bl2 = true;
                    } else {
                        bl2 = process.waitFor(n3, TimeUnit.SECONDS);
                    }
                    string2 = bl2 ? messageWriter.toString() : null;
                }
                catch (InterruptedException interruptedException) {
                    string2 = null;
                }
                if (streamCopyThread2 == null) break block42;
            }
            catch (Throwable throwable) {
                if (streamCopyThread2 != null) {
                    try {
                        streamCopyThread2.halt();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        streamCopyThread2 = null;
                    }
                }
                if (streamCopyThread != null) {
                    try {
                        streamCopyThread.halt();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        streamCopyThread = null;
                    }
                }
                if (process != null) {
                    try {
                        if (process.exitValue() != 0) {
                            commandFailedException = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, string, messageWriter2.toString()));
                        }
                        String string3 = messageWriter.toString();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        commandFailedException = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, string, n2));
                    }
                    process.destroy();
                }
                messageWriter2.close();
                messageWriter.close();
                if (remoteSession != null) {
                    SshSessionFactory.getInstance().releaseSession(remoteSession);
                }
                throw throwable;
            }
            try {
                streamCopyThread2.halt();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                streamCopyThread2 = null;
            }
        }
        if (streamCopyThread != null) {
            try {
                streamCopyThread.halt();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                streamCopyThread = null;
            }
        }
        if (process != null) {
            try {
                if (process.exitValue() != 0) {
                    commandFailedException = new CommandFailedException(process.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, string, messageWriter2.toString()));
                }
                string2 = messageWriter.toString();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                commandFailedException = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, string, n2));
            }
            process.destroy();
        }
        messageWriter2.close();
        messageWriter.close();
        if (remoteSession != null) {
            SshSessionFactory.getInstance().releaseSession(remoteSession);
        }
        if (commandFailedException != null) {
            throw commandFailedException;
        }
        return string2;
    }

    private static int checkTimeout(String string, int n2, long l2) {
        long l3 = System.nanoTime() - l2;
        int n3 = n2 - (int)TimeUnit.NANOSECONDS.toSeconds(l3);
        if (n3 <= 0) {
            throw new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, string, n2));
        }
        return n3;
    }
}

