/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.SimpleLruCache$Entry;

public class SimpleLruCache {
    private Lock lock = new ReentrantLock();
    private Map map = new ConcurrentHashMap();
    private volatile int maximumSize;
    private int purgeSize;
    private volatile long time = 0L;

    private static void checkPurgeFactor(float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidPurgeFactor, Float.valueOf(f2)));
        }
    }

    private static int purgeSize(int n2, float f2) {
        return (int)((1.0f - f2) * (float)n2);
    }

    public SimpleLruCache(int n2, float f2) {
        SimpleLruCache.checkPurgeFactor(f2);
        this.maximumSize = n2;
        this.purgeSize = SimpleLruCache.purgeSize(n2, f2);
    }

    public Object get(Object object) {
        SimpleLruCache$Entry simpleLruCache$Entry = (SimpleLruCache$Entry)this.map.get(object);
        if (simpleLruCache$Entry != null) {
            SimpleLruCache$Entry.access$002(simpleLruCache$Entry, this.tick());
            return SimpleLruCache$Entry.access$100(simpleLruCache$Entry);
        }
        return null;
    }

    public Object put(@NonNull Object object, @NonNull Object object2) {
        this.map.put(object, new SimpleLruCache$Entry(object, object2, this.tick()));
        if (this.map.size() > this.maximumSize) {
            this.purge();
        }
        return object2;
    }

    private long tick() {
        return ++this.time;
    }

    public int size() {
        return this.map.size();
    }

    public void configure(int n2, float f2) {
        this.lock.lock();
        try {
            SimpleLruCache.checkPurgeFactor(f2);
            this.maximumSize = n2;
            this.purgeSize = SimpleLruCache.purgeSize(n2, f2);
            if (this.map.size() >= this.maximumSize) {
                this.purge();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        if (this.lock.tryLock()) {
            try {
                ArrayList arrayList = new ArrayList(this.map.values());
                for (SimpleLruCache$Entry simpleLruCache$Entry2 : arrayList) {
                    simpleLruCache$Entry2.copyAccessTime();
                }
                Collections.sort(arrayList, Comparator.comparingLong(simpleLruCache$Entry -> -SimpleLruCache$Entry.access$300(simpleLruCache$Entry)));
                for (int i2 = this.purgeSize; i2 < arrayList.size(); ++i2) {
                    this.map.remove(SimpleLruCache$Entry.access$200((SimpleLruCache$Entry)arrayList.get(i2)));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

