/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.GpgSignatureVerifier$SignatureVerification;
import org.eclipse.jgit.lib.GpgSignatureVerifier$TrustLevel;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.jgit.util.StringUtils;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static String toString(GpgSignatureVerifier$SignatureVerification gpgSignatureVerifier$SignatureVerification, PersonIdent personIdent, GitDateFormatter gitDateFormatter) {
        StringBuilder stringBuilder = new StringBuilder();
        PersonIdent personIdent2 = new PersonIdent(personIdent, gpgSignatureVerifier$SignatureVerification.getCreationDate());
        stringBuilder.append(MessageFormat.format(JGitText.get().verifySignatureMade, gitDateFormatter.formatDate(personIdent2)));
        stringBuilder.append('\n');
        stringBuilder.append(MessageFormat.format(JGitText.get().verifySignatureKey, gpgSignatureVerifier$SignatureVerification.getKeyFingerprint().toUpperCase(Locale.ROOT)));
        stringBuilder.append('\n');
        if (!StringUtils.isEmptyOrNull(gpgSignatureVerifier$SignatureVerification.getSigner())) {
            stringBuilder.append(MessageFormat.format(JGitText.get().verifySignatureIssuer, gpgSignatureVerifier$SignatureVerification.getSigner()));
            stringBuilder.append('\n');
        }
        String string = gpgSignatureVerifier$SignatureVerification.getVerified() ? (gpgSignatureVerifier$SignatureVerification.isExpired() ? JGitText.get().verifySignatureExpired : JGitText.get().verifySignatureGood) : JGitText.get().verifySignatureBad;
        stringBuilder.append(MessageFormat.format(string, gpgSignatureVerifier$SignatureVerification.getKeyUser()));
        if (!GpgSignatureVerifier$TrustLevel.UNKNOWN.equals((Object)gpgSignatureVerifier$SignatureVerification.getTrustLevel())) {
            stringBuilder.append(' ' + MessageFormat.format(JGitText.get().verifySignatureTrust, gpgSignatureVerifier$SignatureVerification.getTrustLevel().name().toLowerCase(Locale.ROOT)));
        }
        stringBuilder.append('\n');
        string = gpgSignatureVerifier$SignatureVerification.getMessage();
        if (!StringUtils.isEmptyOrNull(string)) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

