/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.SystemReader;

public class RelativeDateFormatter {
    static final long SECOND_IN_MILLIS = 1000L;
    static final long MINUTE_IN_MILLIS = 60000L;
    static final long HOUR_IN_MILLIS = 3600000L;
    static final long DAY_IN_MILLIS = 86400000L;
    static final long WEEK_IN_MILLIS = 604800000L;
    static final long MONTH_IN_MILLIS = 2592000000L;
    static final long YEAR_IN_MILLIS = 31536000000L;

    public static String format(Date date) {
        long l2 = SystemReader.getInstance().getCurrentTime() - date.getTime();
        if (l2 < 0L) {
            return JGitText.get().inTheFuture;
        }
        if (l2 < RelativeDateFormatter.upperLimit(60000L)) {
            return MessageFormat.format(JGitText.get().secondsAgo, RelativeDateFormatter.round(l2, 1000L));
        }
        if (l2 < RelativeDateFormatter.upperLimit(3600000L)) {
            return MessageFormat.format(JGitText.get().minutesAgo, RelativeDateFormatter.round(l2, 60000L));
        }
        if (l2 < RelativeDateFormatter.upperLimit(86400000L)) {
            return MessageFormat.format(JGitText.get().hoursAgo, RelativeDateFormatter.round(l2, 3600000L));
        }
        if (l2 < 1209600000L) {
            return MessageFormat.format(JGitText.get().daysAgo, RelativeDateFormatter.round(l2, 86400000L));
        }
        if (l2 < 6048000000L) {
            return MessageFormat.format(JGitText.get().weeksAgo, RelativeDateFormatter.round(l2, 604800000L));
        }
        if (l2 < 31536000000L) {
            return MessageFormat.format(JGitText.get().monthsAgo, RelativeDateFormatter.round(l2, 2592000000L));
        }
        if (l2 < 157680000000L) {
            long l3 = RelativeDateFormatter.round(l2, 2592000000L) / 12L;
            String string = l3 > 1L ? JGitText.get().years : JGitText.get().year;
            long l4 = RelativeDateFormatter.round(l2 - l3 * 31536000000L, 2592000000L);
            String string2 = l4 > 1L ? JGitText.get().months : (l4 == 1L ? JGitText.get().month : "");
            return MessageFormat.format(l4 == 0L ? JGitText.get().years0MonthsAgo : JGitText.get().yearsMonthsAgo, l3, string, l4, string2);
        }
        return MessageFormat.format(JGitText.get().yearsAgo, RelativeDateFormatter.round(l2, 31536000000L));
    }

    private static long upperLimit(long l2) {
        long l3 = l2 + l2 / 2L;
        return l3;
    }

    private static long round(long l2, long l3) {
        long l4 = (l2 + l3 / 2L) / l3;
        return l4;
    }
}

