/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.AbstractMap;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap$1;

public class RefMap
extends AbstractMap {
    final String prefix;
    RefList packed;
    RefList loose;
    RefList resolved;
    int size;
    boolean sizeIsValid;
    private Set entrySet;

    public RefMap() {
        this.prefix = "";
        this.packed = RefList.emptyList();
        this.loose = RefList.emptyList();
        this.resolved = RefList.emptyList();
    }

    public RefMap(String string, RefList refList, RefList refList2, RefList refList3) {
        this.prefix = string;
        this.packed = refList;
        this.loose = refList2;
        this.resolved = refList3;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public Ref get(Object object) {
        String string = this.toRefName((String)object);
        Ref ref = this.resolved.get(string);
        if (ref == null) {
            ref = this.loose.get(string);
        }
        if (ref == null) {
            ref = this.packed.get(string);
        }
        return ref;
    }

    @Override
    public Ref put(String string, Ref ref) {
        int n2;
        Ref ref22;
        String string2 = this.toRefName(string);
        if (!string2.equals(ref.getName())) {
            throw new IllegalArgumentException();
        }
        if (!this.resolved.isEmpty()) {
            for (Ref ref22 : this.resolved) {
                this.loose = this.loose.put(ref22);
            }
            this.resolved = RefList.emptyList();
        }
        if (0 <= (n2 = this.loose.find(string2))) {
            ref22 = this.loose.get(string2);
            this.loose = this.loose.set(n2, ref);
            return ref22;
        }
        ref22 = this.get(string);
        this.loose = this.loose.add(n2, ref);
        this.sizeIsValid = false;
        return ref22;
    }

    @Override
    public Ref remove(Object object) {
        String string = this.toRefName((String)object);
        Ref ref = null;
        int n2 = this.packed.find(string);
        if (0 <= n2) {
            ref = this.packed.get(string);
            this.packed = this.packed.remove(n2);
            this.sizeIsValid = false;
        }
        if (0 <= (n2 = this.loose.find(string))) {
            ref = this.loose.get(string);
            this.loose = this.loose.remove(n2);
            this.sizeIsValid = false;
        }
        if (0 <= (n2 = this.resolved.find(string))) {
            ref = this.resolved.get(string);
            this.resolved = this.resolved.remove(n2);
            this.sizeIsValid = false;
        }
        return ref;
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new RefMap$1(this);
        }
        return this.entrySet;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        stringBuilder.append('[');
        for (Ref ref : this.values()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(ref);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static Collector toRefMap(BinaryOperator binaryOperator) {
        return Collectors.collectingAndThen(RefList.toRefList(binaryOperator), refList -> new RefMap("", (RefList)refList, RefList.emptyList(), RefList.emptyList()));
    }

    private String toRefName(String string) {
        if (0 < this.prefix.length()) {
            string = this.prefix + string;
        }
        return string;
    }

    String toMapKey(Ref ref) {
        String string = ref.getName();
        if (0 < this.prefix.length()) {
            string = string.substring(this.prefix.length());
        }
        return string;
    }
}

