/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.util.RefList$1;
import org.eclipse.jgit.util.RefList$Builder;

public class RefList
implements Iterable {
    private static final RefList EMPTY = new RefList(new Ref[0], 0);
    final Ref[] list;
    final int cnt;

    public static RefList emptyList() {
        return EMPTY;
    }

    RefList(Ref[] refArray, int n2) {
        this.list = refArray;
        this.cnt = n2;
    }

    protected RefList(RefList refList) {
        this.list = refList.list;
        this.cnt = refList.cnt;
    }

    public Iterator iterator() {
        return new RefList$1(this);
    }

    public final List asList() {
        List<Ref> list = Arrays.asList(this.list).subList(0, this.cnt);
        return Collections.unmodifiableList(list);
    }

    public final int size() {
        return this.cnt;
    }

    public final boolean isEmpty() {
        return this.cnt == 0;
    }

    public final int find(String string) {
        int n2 = this.cnt;
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        do {
            int n4;
            int n5;
            if ((n5 = RefComparator.compareTo(this.list[n4 = n3 + n2 >>> 1], string)) < 0) {
                n3 = n4 + 1;
                continue;
            }
            if (n5 == 0) {
                return n4;
            }
            n2 = n4;
        } while (n3 < n2);
        return -(n3 + 1);
    }

    public final boolean contains(String string) {
        return 0 <= this.find(string);
    }

    public final Ref get(String string) {
        int n2 = this.find(string);
        return 0 <= n2 ? this.get(n2) : null;
    }

    public final Ref get(int n2) {
        return this.list[n2];
    }

    public final RefList$Builder copy(int n2) {
        RefList$Builder refList$Builder = new RefList$Builder(Math.max(16, n2));
        refList$Builder.addAll(this.list, 0, n2);
        return refList$Builder;
    }

    public final RefList set(int n2, Ref ref) {
        Ref[] refArray = new Ref[this.cnt];
        System.arraycopy(this.list, 0, refArray, 0, this.cnt);
        refArray[n2] = ref;
        return new RefList(refArray, this.cnt);
    }

    public final RefList add(int n2, Ref ref) {
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        Ref[] refArray = new Ref[this.cnt + 1];
        if (0 < n2) {
            System.arraycopy(this.list, 0, refArray, 0, n2);
        }
        refArray[n2] = ref;
        if (n2 < this.cnt) {
            System.arraycopy(this.list, n2, refArray, n2 + 1, this.cnt - n2);
        }
        return new RefList(refArray, this.cnt + 1);
    }

    public final RefList remove(int n2) {
        if (this.cnt == 1) {
            return RefList.emptyList();
        }
        Ref[] refArray = new Ref[this.cnt - 1];
        if (0 < n2) {
            System.arraycopy(this.list, 0, refArray, 0, n2);
        }
        if (n2 + 1 < this.cnt) {
            System.arraycopy(this.list, n2 + 1, refArray, n2, this.cnt - (n2 + 1));
        }
        return new RefList(refArray, this.cnt - 1);
    }

    public final RefList put(Ref ref) {
        int n2 = this.find(ref.getName());
        if (0 <= n2) {
            return this.set(n2, ref);
        }
        return this.add(n2, ref);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.cnt > 0) {
            stringBuilder.append(this.list[0]);
            for (int i2 = 1; i2 < this.cnt; ++i2) {
                stringBuilder.append(", ");
                stringBuilder.append(this.list[i2]);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static Collector toRefList(@Nullable BinaryOperator binaryOperator) {
        return Collector.of(() -> new RefList$Builder(), RefList$Builder::add, (refList$Builder, refList$Builder2) -> {
            RefList$Builder refList$Builder3 = new RefList$Builder();
            refList$Builder3.addAll((RefList$Builder)refList$Builder);
            refList$Builder3.addAll((RefList$Builder)refList$Builder2);
            return refList$Builder3;
        }, refList$Builder -> {
            if (binaryOperator != null) {
                refList$Builder.sort();
                refList$Builder.dedupe(binaryOperator);
            }
            return refList$Builder.toRefList();
        }, new Collector.Characteristics[0]);
    }
}

