/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.Arrays;
import java.util.function.BinaryOperator;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.util.RefList;

public class RefList$Builder {
    private Ref[] list;
    private int size;

    public RefList$Builder() {
        this(16);
    }

    public RefList$Builder(int n2) {
        this.list = new Ref[Math.max(n2, 16)];
    }

    public int size() {
        return this.size;
    }

    public Ref get(int n2) {
        return this.list[n2];
    }

    public void remove(int n2) {
        System.arraycopy(this.list, n2 + 1, this.list, n2, this.size - (n2 + 1));
        --this.size;
    }

    public void add(Ref ref) {
        if (this.list.length == this.size) {
            Ref[] refArray = new Ref[this.size * 2];
            System.arraycopy(this.list, 0, refArray, 0, this.size);
            this.list = refArray;
        }
        this.list[this.size++] = ref;
    }

    public void addAll(RefList$Builder refList$Builder) {
        this.addAll(refList$Builder.list, 0, refList$Builder.size);
    }

    public void addAll(Ref[] refArray, int n2, int n3) {
        if (this.list.length < this.size + n3) {
            Ref[] refArray2 = new Ref[Math.max(this.size * 2, this.size + n3)];
            System.arraycopy(this.list, 0, refArray2, 0, this.size);
            this.list = refArray2;
        }
        System.arraycopy(refArray, n2, this.list, this.size, n3);
        this.size += n3;
    }

    public void set(int n2, Ref ref) {
        this.list[n2] = ref;
    }

    public void sort() {
        Arrays.sort(this.list, 0, this.size, RefComparator.INSTANCE);
    }

    void dedupe(BinaryOperator binaryOperator) {
        if (this.size == 0) {
            return;
        }
        int n2 = 0;
        for (int i2 = 1; i2 < this.size; ++i2) {
            if (RefComparator.INSTANCE.compare(this.list[n2], this.list[i2]) == 0) {
                this.list[n2] = (Ref)binaryOperator.apply(this.list[n2], this.list[i2]);
                continue;
            }
            this.list[n2 + 1] = this.list[i2];
            ++n2;
        }
        this.size = n2 + 1;
        Arrays.fill(this.list, this.size, this.list.length, null);
    }

    public RefList toRefList() {
        return new RefList(this.list, this.size);
    }

    public String toString() {
        return this.toRefList().toString();
    }
}

