/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.StringUtils;

public class RawSubStringPattern {
    private final String needleString;
    private final byte[] needle;

    public RawSubStringPattern(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.needleString = string;
        byte[] byArray = Constants.encode(string);
        this.needle = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.needle[i2] = RawSubStringPattern.lc(byArray[i2]);
        }
    }

    public int match(RawCharSequence rawCharSequence) {
        int n2 = this.needle.length;
        byte by = this.needle[0];
        byte[] byArray = rawCharSequence.buffer;
        int n3 = rawCharSequence.endPtr - n2;
        block0: for (int i2 = rawCharSequence.startPtr; i2 <= n3; ++i2) {
            if (RawSubStringPattern.neq(by, byArray[i2])) {
                while (++i2 <= n3 && RawSubStringPattern.neq(by, byArray[i2])) {
                }
                if (i2 > n3) {
                    return -1;
                }
            }
            int n4 = i2 + 1;
            int n5 = 1;
            while (n5 < n2) {
                if (RawSubStringPattern.neq(this.needle[n5], byArray[n4])) continue block0;
                ++n5;
                ++n4;
            }
            return i2;
        }
        return -1;
    }

    private static final boolean neq(byte by, byte by2) {
        return by != by2 && by != RawSubStringPattern.lc(by2);
    }

    private static final byte lc(byte by) {
        return (byte)StringUtils.toLowerCase((char)(by & 0xFF));
    }

    public String pattern() {
        return this.needleString;
    }

    public String toString() {
        return this.pattern();
    }
}

