/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.InvalidCharset;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.StringUtils;

public final class RawParseUtils {
    @Deprecated
    public static final Charset UTF8_CHARSET;
    private static final byte[] digits10;
    private static final byte[] digits16;
    private static final byte[] footerLineKeyChars;
    private static final Map encodingAliases;
    private static final byte[] base10byte;

    public static final int match(byte[] byArray, int n2, byte[] byArray2) {
        if (n2 + byArray2.length > byArray.length) {
            return -1;
        }
        int n3 = 0;
        while (n3 < byArray2.length) {
            if (byArray[n2] != byArray2[n3]) {
                return -1;
            }
            ++n3;
            ++n2;
        }
        return n2;
    }

    public static int formatBase10(byte[] byArray, int n2, int n3) {
        boolean bl2;
        if (n3 == 0) {
            byArray[--n2] = 48;
            return n2;
        }
        boolean bl3 = bl2 = n3 < 0;
        if (bl2) {
            n3 = -n3;
        }
        while (n3 != 0) {
            byArray[--n2] = base10byte[n3 % 10];
            n3 /= 10;
        }
        if (bl2) {
            byArray[--n2] = 45;
        }
        return n2;
    }

    public static final int parseBase10(byte[] byArray, int n2, MutableInteger mutableInteger) {
        int n3 = 0;
        int n4 = 0;
        try {
            byte by;
            int n5 = byArray.length;
            while (n2 < n5 && byArray[n2] == 32) {
                ++n2;
            }
            if (n2 >= n5) {
                return 0;
            }
            switch (byArray[n2]) {
                case 45: {
                    n4 = -1;
                    ++n2;
                    break;
                }
                case 43: {
                    ++n2;
                }
            }
            while (n2 < n5 && (by = digits10[byArray[n2]]) >= 0) {
                n3 = n3 * 10 + by;
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (mutableInteger != null) {
            mutableInteger.value = n2;
        }
        return n4 < 0 ? -n3 : n3;
    }

    public static final long parseLongBase10(byte[] byArray, int n2, MutableInteger mutableInteger) {
        long l2 = 0L;
        int n3 = 0;
        try {
            byte by;
            int n4 = byArray.length;
            while (n2 < n4 && byArray[n2] == 32) {
                ++n2;
            }
            if (n2 >= n4) {
                return 0L;
            }
            switch (byArray[n2]) {
                case 45: {
                    n3 = -1;
                    ++n2;
                    break;
                }
                case 43: {
                    ++n2;
                }
            }
            while (n2 < n4 && (by = digits10[byArray[n2]]) >= 0) {
                l2 = l2 * 10L + (long)by;
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (mutableInteger != null) {
            mutableInteger.value = n2;
        }
        return n3 < 0 ? -l2 : l2;
    }

    public static final int parseHexInt16(byte[] byArray, int n2) {
        int n3 = digits16[byArray[n2]] << 4;
        n3 |= digits16[byArray[n2 + 1]];
        n3 <<= 4;
        n3 |= digits16[byArray[n2 + 2]];
        n3 <<= 4;
        if ((n3 |= digits16[byArray[n2 + 3]]) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n3;
    }

    public static final int parseHexInt32(byte[] byArray, int n2) {
        int n3 = digits16[byArray[n2]] << 4;
        n3 |= digits16[byArray[n2 + 1]];
        n3 <<= 4;
        n3 |= digits16[byArray[n2 + 2]];
        n3 <<= 4;
        n3 |= digits16[byArray[n2 + 3]];
        n3 <<= 4;
        n3 |= digits16[byArray[n2 + 4]];
        n3 <<= 4;
        n3 |= digits16[byArray[n2 + 5]];
        n3 <<= 4;
        byte by = digits16[byArray[n2 + 7]];
        if ((n3 |= digits16[byArray[n2 + 6]]) < 0 || by < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n3 << 4 | by;
    }

    public static final long parseHexInt64(byte[] byArray, int n2) {
        long l2 = digits16[byArray[n2]] << 4;
        l2 |= (long)digits16[byArray[n2 + 1]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 2]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 3]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 4]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 5]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 6]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 7]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 8]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 9]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 10]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 11]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 12]];
        l2 <<= 4;
        l2 |= (long)digits16[byArray[n2 + 13]];
        l2 <<= 4;
        byte by = digits16[byArray[n2 + 15]];
        if ((l2 |= (long)digits16[byArray[n2 + 14]]) < 0L || by < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return l2 << 4 | (long)by;
    }

    public static final int parseHexInt4(byte by) {
        byte by2 = digits16[by];
        if (by2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return by2;
    }

    public static final int parseTimeZoneOffset(byte[] byArray, int n2) {
        return RawParseUtils.parseTimeZoneOffset(byArray, n2, null);
    }

    public static final int parseTimeZoneOffset(byte[] byArray, int n2, MutableInteger mutableInteger) {
        int n3 = RawParseUtils.parseBase10(byArray, n2, mutableInteger);
        int n4 = n3 % 100;
        int n5 = n3 / 100;
        return n5 * 60 + n4;
    }

    public static final int next(byte[] byArray, int n2, char c2) {
        int n3 = byArray.length;
        while (n2 < n3) {
            if (byArray[n2++] != c2) continue;
            return n2;
        }
        return n2;
    }

    public static final int nextLF(byte[] byArray, int n2) {
        return RawParseUtils.next(byArray, n2, '\n');
    }

    public static final int nextLF(byte[] byArray, int n2, char c2) {
        int n3 = byArray.length;
        while (n2 < n3) {
            byte by;
            if ((by = byArray[n2++]) != c2 && by != 10) continue;
            return n2;
        }
        return n2;
    }

    public static final int headerEnd(byte[] byArray, int n2) {
        int n3 = byArray.length;
        while (n2 < n3) {
            byte by;
            if ((by = byArray[n2++]) != 10 || n2 != n3 && byArray[n2] == 32) continue;
            return n2 - 1;
        }
        return n2 - 1;
    }

    public static final int headerStart(byte[] byArray, byte[] byArray2, int n2) {
        if (n2 != 0) {
            n2 = RawParseUtils.nextLF(byArray2, n2 - 1);
        }
        while (n2 < byArray2.length - (byArray.length + 1)) {
            boolean bl2 = true;
            for (byte by : byArray) {
                if (by == byArray2[n2++]) continue;
                bl2 = false;
                break;
            }
            if (bl2 && byArray2[n2++] == 32) {
                return n2;
            }
            n2 = RawParseUtils.nextLF(byArray2, n2);
        }
        return -1;
    }

    public static final int prev(byte[] byArray, int n2, char c2) {
        if (n2 == byArray.length) {
            --n2;
        }
        while (n2 >= 0) {
            if (byArray[n2--] != c2) continue;
            return n2;
        }
        return n2;
    }

    public static final int prevLF(byte[] byArray, int n2) {
        return RawParseUtils.prev(byArray, n2, '\n');
    }

    public static final int prevLF(byte[] byArray, int n2, char c2) {
        if (n2 == byArray.length) {
            --n2;
        }
        while (n2 >= 0) {
            byte by;
            if ((by = byArray[n2--]) != c2 && by != 10) continue;
            return n2;
        }
        return n2;
    }

    public static final IntList lineMap(byte[] byArray, int n2, int n3) {
        IntList intList = new IntList((n3 - n2) / 36);
        intList.fillTo(1, Integer.MIN_VALUE);
        while (n2 < n3) {
            intList.add(n2);
            n2 = RawParseUtils.nextLF(byArray, n2);
        }
        intList.add(n3);
        return intList;
    }

    public static final IntList lineMapOrBinary(byte[] byArray, int n2, int n3) {
        IntList intList = RawParseUtils.lineMapOrNull(byArray, n2, n3);
        if (intList == null) {
            throw new BinaryBlobException();
        }
        return intList;
    }

    @Nullable
    private static IntList lineMapOrNull(byte[] byArray, int n2, int n3) {
        IntList intList = new IntList((n3 - n2) / 36);
        intList.add(Integer.MIN_VALUE);
        boolean bl2 = true;
        while (n2 < n3) {
            if (bl2) {
                intList.add(n2);
            }
            if (byArray[n2] == 0) {
                return null;
            }
            bl2 = byArray[n2] == 10;
            ++n2;
        }
        intList.add(n3);
        return intList;
    }

    public static final int author(byte[] byArray, int n2) {
        int n3 = byArray.length;
        if (n2 == 0) {
            n2 += 46;
        }
        while (n2 < n3 && byArray[n2] == 112) {
            n2 += 48;
        }
        return RawParseUtils.match(byArray, n2, ObjectChecker.author);
    }

    public static final int committer(byte[] byArray, int n2) {
        int n3 = byArray.length;
        if (n2 == 0) {
            n2 += 46;
        }
        while (n2 < n3 && byArray[n2] == 112) {
            n2 += 48;
        }
        if (n2 < n3 && byArray[n2] == 97) {
            n2 = RawParseUtils.nextLF(byArray, n2);
        }
        return RawParseUtils.match(byArray, n2, ObjectChecker.committer);
    }

    public static final int tagger(byte[] byArray, int n2) {
        int n3 = byArray.length;
        if (n2 == 0) {
            n2 += 48;
        }
        while (n2 < n3) {
            if (byArray[n2] == 10) {
                return -1;
            }
            int n4 = RawParseUtils.match(byArray, n2, ObjectChecker.tagger);
            if (n4 >= 0) {
                return n4;
            }
            n2 = RawParseUtils.nextLF(byArray, n2);
        }
        return -1;
    }

    public static final int encoding(byte[] byArray, int n2) {
        int n3 = byArray.length;
        while (n2 < n3) {
            if (byArray[n2] == 10) {
                return -1;
            }
            if (byArray[n2] == 101) break;
            n2 = RawParseUtils.nextLF(byArray, n2);
        }
        return RawParseUtils.match(byArray, n2, ObjectChecker.encoding);
    }

    @Nullable
    public static String parseEncodingName(byte[] byArray) {
        int n2 = RawParseUtils.encoding(byArray, 0);
        if (n2 < 0) {
            return null;
        }
        int n3 = RawParseUtils.nextLF(byArray, n2);
        return RawParseUtils.decode(StandardCharsets.UTF_8, byArray, n2, n3 - 1);
    }

    public static Charset parseEncoding(byte[] byArray) {
        String string = RawParseUtils.parseEncodingName(byArray);
        if (string == null) {
            return StandardCharsets.UTF_8;
        }
        String string2 = string.trim();
        try {
            return Charset.forName(string2);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            Charset charset = RawParseUtils.charsetForAlias(string2);
            if (charset != null) {
                return charset;
            }
            return InvalidCharset.INSTANCE;
        }
    }

    public static PersonIdent parsePersonIdent(String string) {
        return RawParseUtils.parsePersonIdent(Constants.encode(string), 0);
    }

    public static PersonIdent parsePersonIdent(byte[] byArray, int n2) {
        Charset charset;
        try {
            charset = RawParseUtils.parseEncoding(byArray);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            charset = StandardCharsets.UTF_8;
        }
        int n3 = RawParseUtils.nextLF(byArray, n2, '<');
        int n4 = RawParseUtils.nextLF(byArray, n3, '>');
        if (n3 >= byArray.length || byArray[n3] == 10 || n4 >= byArray.length - 1 && byArray[n4 - 1] != 62) {
            return null;
        }
        int n5 = n3 - 2 >= n2 && byArray[n3 - 2] == 32 ? n3 - 2 : n3 - 1;
        String string = RawParseUtils.decode(charset, byArray, n2, n5);
        String string2 = RawParseUtils.decode(charset, byArray, n3, n4 - 1);
        int n6 = RawParseUtils.lastIndexOfTrim(byArray, ' ', RawParseUtils.nextLF(byArray, n4 - 1) - 2) + 1;
        if (n6 <= n4) {
            return new PersonIdent(string, string2, 0L, 0);
        }
        int n7 = Math.max(n4, RawParseUtils.lastIndexOfTrim(byArray, ' ', n6 - 1) + 1);
        if (n7 >= n6 - 1) {
            return new PersonIdent(string, string2, 0L, 0);
        }
        long l2 = RawParseUtils.parseLongBase10(byArray, n7, null);
        int n8 = RawParseUtils.parseTimeZoneOffset(byArray, n6);
        return new PersonIdent(string, string2, l2 * 1000L, n8);
    }

    public static PersonIdent parsePersonIdentOnly(byte[] byArray, int n2) {
        int n3;
        long l2;
        int n4 = RawParseUtils.nextLF(byArray, n2);
        int n5 = RawParseUtils.nextLF(byArray, n2, '<');
        int n6 = RawParseUtils.nextLF(byArray, n5, '>');
        String string = n6 < n4 ? RawParseUtils.decode(byArray, n5, n6 - 1) : "invalid";
        String string2 = n5 < n4 ? RawParseUtils.decode(byArray, n2, n5 - 2) : RawParseUtils.decode(byArray, n2, n4);
        MutableInteger mutableInteger = new MutableInteger();
        if (n6 < n4) {
            l2 = RawParseUtils.parseLongBase10(byArray, n6 + 1, mutableInteger);
            n3 = RawParseUtils.parseTimeZoneOffset(byArray, mutableInteger.value);
        } else {
            l2 = 0L;
            n3 = 0;
        }
        return new PersonIdent(string2, string, l2 * 1000L, n3);
    }

    public static int endOfFooterLineKey(byte[] byArray, int n2) {
        try {
            while (true) {
                byte by;
                if (footerLineKeyChars[by = byArray[n2]] == 0) {
                    if (by == 58) {
                        return n2;
                    }
                    return -1;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public static String decode(byte[] byArray) {
        return RawParseUtils.decode(byArray, 0, byArray.length);
    }

    public static String decode(byte[] byArray, int n2, int n3) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, byArray, n2, n3);
    }

    public static String decode(Charset charset, byte[] byArray) {
        return RawParseUtils.decode(charset, byArray, 0, byArray.length);
    }

    public static String decode(Charset charset, byte[] byArray, int n2, int n3) {
        try {
            return RawParseUtils.decodeNoFallback(charset, byArray, n2, n3);
        }
        catch (CharacterCodingException characterCodingException) {
            return RawParseUtils.extractBinaryString(byArray, n2, n3);
        }
    }

    public static String decodeNoFallback(Charset charset, byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3 - n2);
        byteBuffer.mark();
        try {
            return RawParseUtils.decode(byteBuffer, StandardCharsets.UTF_8);
        }
        catch (CharacterCodingException characterCodingException) {
            Charset charset2;
            byteBuffer.reset();
            if (!charset.equals(StandardCharsets.UTF_8)) {
                try {
                    return RawParseUtils.decode(byteBuffer, charset);
                }
                catch (CharacterCodingException characterCodingException2) {
                    byteBuffer.reset();
                }
            }
            if (!(charset2 = Charset.defaultCharset()).equals(charset) && !charset2.equals(StandardCharsets.UTF_8)) {
                try {
                    return RawParseUtils.decode(byteBuffer, charset2);
                }
                catch (CharacterCodingException characterCodingException3) {
                    byteBuffer.reset();
                }
            }
            throw new CharacterCodingException();
        }
    }

    public static String extractBinaryString(byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        for (int i2 = n2; i2 < n3; ++i2) {
            stringBuilder.append((char)(byArray[i2] & 0xFF));
        }
        return stringBuilder.toString();
    }

    private static String decode(ByteBuffer byteBuffer, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        return charsetDecoder.decode(byteBuffer).toString();
    }

    public static final int commitMessage(byte[] byArray, int n2) {
        int n3 = byArray.length;
        if (n2 == 0) {
            n2 += 46;
        }
        while (n2 < n3 && byArray[n2] == 112) {
            n2 += 48;
        }
        return RawParseUtils.tagMessage(byArray, n2);
    }

    public static final int tagMessage(byte[] byArray, int n2) {
        int n3 = byArray.length;
        if (n2 == 0) {
            n2 += 48;
        }
        while (n2 < n3 && byArray[n2] != 10) {
            n2 = RawParseUtils.nextLF(byArray, n2);
        }
        if (n2 < n3 && byArray[n2] == 10) {
            return n2 + 1;
        }
        return -1;
    }

    public static final int endOfParagraph(byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = byArray.length;
        while (n3 < n4 && byArray[n3] != 10 && byArray[n3] != 13) {
            n3 = RawParseUtils.nextLF(byArray, n3);
        }
        if (n3 > n2 && byArray[n3 - 1] == 10) {
            --n3;
        }
        if (n3 > n2 && byArray[n3 - 1] == 13) {
            --n3;
        }
        return n3;
    }

    public static int lastIndexOfTrim(byte[] byArray, char c2, int n2) {
        while (n2 >= 0 && byArray[n2] == 32) {
            --n2;
        }
        while (n2 >= 0 && byArray[n2] != c2) {
            --n2;
        }
        return n2;
    }

    private static Charset charsetForAlias(String string) {
        return (Charset)encodingAliases.get(StringUtils.toLowerCase(string));
    }

    private RawParseUtils() {
    }

    static {
        int n2;
        UTF8_CHARSET = StandardCharsets.UTF_8;
        encodingAliases = new HashMap();
        encodingAliases.put("latin-1", StandardCharsets.ISO_8859_1);
        encodingAliases.put("iso-latin-1", StandardCharsets.ISO_8859_1);
        digits10 = new byte[58];
        Arrays.fill(digits10, (byte)-1);
        for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.digits10[n2] = (byte)(n2 - 48);
        }
        digits16 = new byte[103];
        Arrays.fill(digits16, (byte)-1);
        for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.digits16[n2] = (byte)(n2 - 48);
        }
        for (n2 = 97; n2 <= 102; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.digits16[n2] = (byte)(n2 - 97 + 10);
        }
        for (n2 = 65; n2 <= 70; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.digits16[n2] = (byte)(n2 - 65 + 10);
        }
        footerLineKeyChars = new byte[123];
        RawParseUtils.footerLineKeyChars[45] = 1;
        for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.footerLineKeyChars[n2] = 1;
        }
        for (n2 = 65; n2 <= 90; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.footerLineKeyChars[n2] = 1;
        }
        for (n2 = 97; n2 <= 122; n2 = (int)((char)(n2 + 1))) {
            RawParseUtils.footerLineKeyChars[n2] = 1;
        }
        base10byte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }
}

