/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitoring {
    private static final Logger LOG = LoggerFactory.getLogger(Monitoring.class);

    @Nullable
    public static ObjectInstance registerMBean(Object object, String string) {
        Object object2;
        boolean bl2 = false;
        try {
            object2 = object.getClass().getInterfaces();
            for (Class<?> clazz : object2) {
                bl2 = SystemReader.getInstance().getUserConfig().getBoolean("jmx", clazz.getSimpleName(), false);
                if (!bl2) {
                    continue;
                }
                break;
            }
        }
        catch (IOException | ConfigInvalidException exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
        if (!bl2) {
            return null;
        }
        object2 = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName jMException = Monitoring.objectName(object.getClass(), string);
            if (object2.isRegistered(jMException)) {
                object2.unregisterMBean(jMException);
            }
            return object2.registerMBean(object, jMException);
        }
        catch (InstanceAlreadyExistsException | InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            LOG.error(jMException.getMessage(), (Throwable)jMException);
            return null;
        }
    }

    private static ObjectName objectName(Class clazz, String string) {
        return new ObjectName(String.format("org.eclipse.jgit/%s:type=%s", string, clazz.getSimpleName()));
    }
}

