/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import org.eclipse.jgit.util.LongMap$Node;

public class LongMap {
    private static final float LOAD_FACTOR = 0.75f;
    private LongMap$Node[] table = LongMap.createArray(64);
    private int size;
    private int growAt = (int)((float)this.table.length * 0.75f);

    public boolean containsKey(long l2) {
        return this.get(l2) != null;
    }

    public Object get(long l2) {
        LongMap$Node longMap$Node = this.table[this.index(l2)];
        while (longMap$Node != null) {
            if (longMap$Node.key == l2) {
                return longMap$Node.value;
            }
            longMap$Node = longMap$Node.next;
        }
        return null;
    }

    public Object remove(long l2) {
        LongMap$Node longMap$Node = this.table[this.index(l2)];
        LongMap$Node longMap$Node2 = null;
        while (longMap$Node != null) {
            if (longMap$Node.key == l2) {
                if (longMap$Node2 == null) {
                    this.table[this.index((long)l2)] = longMap$Node.next;
                } else {
                    longMap$Node2.next = longMap$Node.next;
                }
                --this.size;
                return longMap$Node.value;
            }
            longMap$Node2 = longMap$Node;
            longMap$Node = longMap$Node.next;
        }
        return null;
    }

    public Object put(long l2, Object object) {
        LongMap$Node longMap$Node = this.table[this.index(l2)];
        while (longMap$Node != null) {
            if (longMap$Node.key == l2) {
                Object object2 = longMap$Node.value;
                longMap$Node.value = object;
                return object2;
            }
            longMap$Node = longMap$Node.next;
        }
        if (++this.size == this.growAt) {
            this.grow();
        }
        this.insert(new LongMap$Node(l2, object));
        return null;
    }

    private void insert(LongMap$Node longMap$Node) {
        int n2 = this.index(longMap$Node.key);
        longMap$Node.next = this.table[n2];
        this.table[n2] = longMap$Node;
    }

    private void grow() {
        LongMap$Node[] longMap$NodeArray = this.table;
        int n2 = this.table.length;
        this.table = LongMap.createArray(n2 << 1);
        this.growAt = (int)((float)this.table.length * 0.75f);
        for (int i2 = 0; i2 < n2; ++i2) {
            LongMap$Node longMap$Node = longMap$NodeArray[i2];
            while (longMap$Node != null) {
                LongMap$Node longMap$Node2 = longMap$Node.next;
                this.insert(longMap$Node);
                longMap$Node = longMap$Node2;
            }
        }
    }

    private final int index(long l2) {
        int n2 = (int)l2 >>> 1;
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 & this.table.length - 1;
    }

    private static final LongMap$Node[] createArray(int n2) {
        return new LongMap$Node[n2];
    }
}

