/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.Arrays;

public class LongList {
    private long[] entries;
    private int count;

    public LongList() {
        this(10);
    }

    public LongList(int n2) {
        this.entries = new long[n2];
    }

    public int size() {
        return this.count;
    }

    public long get(int n2) {
        if (this.count <= n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.entries[n2];
    }

    public boolean contains(long l2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.entries[i2] != l2) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
    }

    public void add(long l2) {
        if (this.count == this.entries.length) {
            this.grow();
        }
        this.entries[this.count++] = l2;
    }

    public void set(int n2, long l2) {
        if (this.count < n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (this.count == n2) {
            this.add(l2);
        } else {
            this.entries[n2] = l2;
        }
    }

    public void fillTo(int n2, long l2) {
        while (this.count < n2) {
            this.add(l2);
        }
    }

    public void sort() {
        Arrays.sort(this.entries, 0, this.count);
    }

    private void grow() {
        long[] lArray = new long[(this.entries.length + 16) * 3 / 2];
        System.arraycopy(this.entries, 0, lArray, 0, this.count);
        this.entries = lArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.entries[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

