/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.LfsFactory$LfsInputStream;

public class LfsFactory {
    private static LfsFactory instance = new LfsFactory();

    protected LfsFactory() {
    }

    public static LfsFactory getInstance() {
        return instance;
    }

    public static void setInstance(LfsFactory lfsFactory) {
        instance = lfsFactory;
    }

    public boolean isAvailable() {
        return false;
    }

    public LfsFactory$LfsInputStream applyCleanFilter(Repository repository, InputStream inputStream, long l2, Attribute attribute) {
        return new LfsFactory$LfsInputStream(inputStream, l2);
    }

    public ObjectLoader applySmudgeFilter(Repository repository, ObjectLoader objectLoader, Attribute attribute) {
        return objectLoader;
    }

    @Nullable
    public PrePushHook getPrePushHook(Repository repository, PrintStream printStream) {
        return null;
    }

    @Nullable
    public PrePushHook getPrePushHook(Repository repository, PrintStream printStream, PrintStream printStream2) {
        return this.getPrePushHook(repository, printStream);
    }

    @Nullable
    public LfsInstallCommand getInstallCommand() {
        return null;
    }

    public boolean isEnabled(Repository repository) {
        return false;
    }

    public static Attributes getAttributesForPath(Repository repository, String string) {
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            treeWalk.addTree(new FileTreeIterator(repository));
            PathFilter pathFilter = PathFilter.create(string);
            treeWalk.setFilter(pathFilter);
            treeWalk.setRecursive(false);
            Attributes attributes = null;
            while (treeWalk.next()) {
                if (pathFilter.isDone(treeWalk)) {
                    attributes = treeWalk.getAttributes();
                    break;
                }
                if (!treeWalk.isSubtree()) continue;
                treeWalk.enterSubtree();
            }
            if (attributes == null) {
                throw new IOException(MessageFormat.format(JGitText.get().noPathAttributesFound, string));
            }
            Attributes attributes2 = attributes;
            return attributes2;
        }
    }

    public static Attributes getAttributesForPath(Repository repository, String string, RevCommit revCommit) {
        if (revCommit == null) {
            return LfsFactory.getAttributesForPath(repository, string);
        }
        try (TreeWalk treeWalk = TreeWalk.forPath(repository, string, revCommit.getTree());){
            Attributes attributes;
            Attributes attributes2 = attributes = treeWalk == null ? null : treeWalk.getAttributes();
            if (attributes == null) {
                throw new IOException(MessageFormat.format(JGitText.get().noPathAttributesFound, string));
            }
            Attributes attributes3 = attributes;
            return attributes3;
        }
    }
}

