/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

public class IntList {
    private int[] entries;
    private int count;

    public IntList() {
        this(10);
    }

    public IntList(int n2) {
        this.entries = new int[n2];
    }

    public int size() {
        return this.count;
    }

    public boolean contains(int n2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.entries[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public int get(int n2) {
        if (this.count <= n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.entries[n2];
    }

    public void clear() {
        this.count = 0;
    }

    public void add(int n2) {
        if (this.count == this.entries.length) {
            this.grow();
        }
        this.entries[this.count++] = n2;
    }

    public void set(int n2, int n3) {
        if (this.count < n2) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (this.count == n2) {
            this.add(n3);
        } else {
            this.entries[n2] = n3;
        }
    }

    public void fillTo(int n2, int n3) {
        while (this.count < n2) {
            this.add(n3);
        }
    }

    private void grow() {
        int[] nArray = new int[(this.entries.length + 16) * 3 / 2];
        System.arraycopy(this.entries, 0, nArray, 0, this.count);
        this.entries = nArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.entries[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

