/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.TemporaryBuffer$Heap;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public class IO {
    public static final byte[] readFully(File file) {
        return IO.readFully(file, Integer.MAX_VALUE);
    }

    public static final byte[] readSome(File file, int n2) {
        try (SilentFileInputStream silentFileInputStream = new SilentFileInputStream(file);){
            int n3;
            byte[] byArray = new byte[n2];
            int n4 = 0;
            while ((n3 = silentFileInputStream.read(byArray, n4, byArray.length - n4)) > 0) {
                n4 += n3;
            }
            if (n4 == byArray.length) {
                byte[] byArray2 = byArray;
                return byArray2;
            }
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray, 0, byArray3, 0, n4);
            byte[] byArray4 = byArray3;
            return byArray4;
        }
    }

    public static final byte[] readFully(File file, int n2) {
        try (SilentFileInputStream silentFileInputStream = new SilentFileInputStream(file);){
            long l2 = Math.max(file.length(), 1L);
            if (l2 > (long)n2) {
                throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, file));
            }
            byte[] byArray = new byte[(int)l2];
            int n3 = 0;
            while (true) {
                int n4;
                if (byArray.length == n3) {
                    if (byArray.length == n2) {
                        n4 = silentFileInputStream.read();
                        if (n4 < 0) break;
                        throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, file));
                    }
                    byte[] byArray2 = new byte[Math.min(byArray.length * 2, n2)];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
                if ((n4 = silentFileInputStream.read(byArray, n3, byArray.length - n3)) < 0) break;
                n3 += n4;
            }
            if (n3 < byArray.length) {
                byte[] byArray3 = new byte[n3];
                System.arraycopy(byArray, 0, byArray3, 0, n3);
                byArray = byArray3;
            }
            byte[] byArray4 = byArray;
            return byArray4;
        }
    }

    public static ByteBuffer readWholeStream(InputStream inputStream, int n2) {
        int n3;
        int n4;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < byArray.length; n3 += n4) {
            n4 = inputStream.read(byArray, n3, byArray.length - n3);
            if (n4 >= 0) continue;
            return ByteBuffer.wrap(byArray, 0, n3);
        }
        n4 = inputStream.read();
        if (n4 < 0) {
            return ByteBuffer.wrap(byArray, 0, n3);
        }
        try (TemporaryBuffer$Heap temporaryBuffer$Heap = new TemporaryBuffer$Heap(Integer.MAX_VALUE);){
            temporaryBuffer$Heap.write(byArray);
            temporaryBuffer$Heap.write(n4);
            temporaryBuffer$Heap.copy(inputStream);
            ByteBuffer byteBuffer = ByteBuffer.wrap(temporaryBuffer$Heap.toByteArray());
            return byteBuffer;
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = inputStream.read(byArray, n2, n3);
            if (n4 <= 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    public static int read(ReadableByteChannel readableByteChannel, byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        int n5 = 0;
        while (0 < n3 && (n4 = readableByteChannel.read(ByteBuffer.wrap(byArray, n2, n3))) > 0) {
            n2 += n4;
            n3 -= n4;
            n5 += n4;
        }
        return n5 != 0 ? n5 : -1;
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n2) {
        int n3;
        int n4 = 0;
        while (n2 < byArray.length && (n3 = inputStream.read(byArray, n2, byArray.length - n2)) >= 0) {
            n2 += n3;
            n4 += n3;
        }
        return n4;
    }

    public static void skipFully(InputStream inputStream, long l2) {
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            l2 -= l3;
        }
    }

    public static List readLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\n') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            if (c2 == '\r') {
                if (i2 + 1 < string.length()) {
                    c2 = string.charAt(++i2);
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    if (c2 == '\n') continue;
                    stringBuilder.append(c2);
                    continue;
                }
                arrayList.add(stringBuilder.toString());
                break;
            }
            stringBuilder.append(c2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    public static String readLine(Reader reader, int n2) {
        int n3;
        StringBuilder stringBuilder;
        if (reader.markSupported()) {
            if (n2 <= 0) {
                n2 = 1024;
            }
            StringBuilder stringBuilder2 = new StringBuilder(n2);
            char[] cArray = new char[n2];
            while (true) {
                reader.mark(n2);
                int n4 = reader.read(cArray);
                if (n4 < 0) {
                    reader.reset();
                    return stringBuilder2.toString();
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (cArray[i2] != '\n') continue;
                    IO.resetAndSkipFully(reader, ++i2);
                    stringBuilder2.append(cArray, 0, i2);
                    return stringBuilder2.toString();
                }
                if (n4 > 0) {
                    stringBuilder2.append(cArray, 0, n4);
                }
                IO.resetAndSkipFully(reader, n4);
            }
        }
        StringBuilder stringBuilder3 = stringBuilder = n2 > 0 ? new StringBuilder(n2) : new StringBuilder();
        while ((n3 = reader.read()) != -1) {
            char c2 = (char)n3;
            stringBuilder.append(c2);
            if (c2 != '\n') continue;
            break;
        }
        return stringBuilder.toString();
    }

    private static void resetAndSkipFully(Reader reader, long l2) {
        reader.reset();
        while (l2 > 0L) {
            long l3 = reader.skip(l2);
            if (l3 <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            l2 -= l3;
        }
    }

    private IO() {
    }
}

