/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.NoCheckX509TrustManager;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSupport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSupport.class);
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_POST = "POST";
    public static final String HDR_CACHE_CONTROL = "Cache-Control";
    public static final String HDR_PRAGMA = "Pragma";
    public static final String HDR_USER_AGENT = "User-Agent";
    public static final String HDR_SERVER = "Server";
    public static final String HDR_DATE = "Date";
    public static final String HDR_EXPIRES = "Expires";
    public static final String HDR_ETAG = "ETag";
    public static final String HDR_IF_NONE_MATCH = "If-None-Match";
    public static final String HDR_LAST_MODIFIED = "Last-Modified";
    public static final String HDR_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HDR_ACCEPT = "Accept";
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    public static final String HDR_CONTENT_LENGTH = "Content-Length";
    public static final String HDR_CONTENT_ENCODING = "Content-Encoding";
    public static final String HDR_CONTENT_RANGE = "Content-Range";
    public static final String HDR_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HDR_IF_RANGE = "If-Range";
    public static final String HDR_RANGE = "Range";
    public static final String HDR_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HDR_LOCATION = "Location";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ENCODING_X_GZIP = "x-gzip";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String HDR_AUTHORIZATION = "Authorization";
    public static final String HDR_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HDR_COOKIE = "Cookie";
    public static final String HDR_SET_COOKIE = "Set-Cookie";
    public static final String HDR_SET_COOKIE2 = "Set-Cookie2";
    private static Set configuredHttpsProtocols;

    public static void encode(StringBuilder stringBuilder, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            stringBuilder.append(URLEncoder.encode(string, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(JGitText.get().couldNotURLEncodeToUTF8, unsupportedEncodingException);
        }
    }

    public static String urlEncode(String string, boolean bl2) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(JGitText.get().couldNotURLEncodeToUTF8, unsupportedEncodingException);
        }
        if (bl2) {
            string2 = string2.replace("%2F", "/");
        }
        return string2;
    }

    public static int response(HttpConnection httpConnection) {
        try {
            return httpConnection.getResponseCode();
        }
        catch (ConnectException connectException) {
            String string;
            URL uRL = httpConnection.getURL();
            String string2 = string = uRL == null ? "<null>" : uRL.getHost();
            if ("Connection timed out: connect".equals(connectException.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, string));
            }
            throw new ConnectException(connectException.getMessage() + " " + string);
        }
    }

    public static int response(HttpURLConnection httpURLConnection) {
        try {
            return httpURLConnection.getResponseCode();
        }
        catch (ConnectException connectException) {
            String string;
            URL uRL = httpURLConnection.getURL();
            String string2 = string = uRL == null ? "<null>" : uRL.getHost();
            if ("Connection timed out: connect".equals(connectException.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, string));
            }
            throw new ConnectException(connectException.getMessage() + " " + string);
        }
    }

    public static String responseHeader(HttpConnection httpConnection, String string) {
        return httpConnection.getHeaderField(string);
    }

    public static Proxy proxyFor(ProxySelector proxySelector, URL uRL) {
        try {
            URI uRI = new URI(uRL.getProtocol(), null, uRL.getHost(), uRL.getPort(), null, null, null);
            return proxySelector.select(uRI).get(0);
        }
        catch (URISyntaxException uRISyntaxException) {
            ConnectException connectException = new ConnectException(MessageFormat.format(JGitText.get().cannotDetermineProxyFor, uRL));
            connectException.initCause(uRISyntaxException);
            throw connectException;
        }
    }

    public static void disableSslVerify(HttpConnection httpConnection) {
        TrustManager[] trustManagerArray = new TrustManager[]{new NoCheckX509TrustManager()};
        try {
            httpConnection.configure(null, trustManagerArray, null);
            httpConnection.setHostnameVerifier((string, sSLSession) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new IOException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public static void configureTLS(SSLSocket sSLSocket) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(sSLSocket.getEnabledProtocols()));
        for (String string : sSLSocket.getSupportedProtocols()) {
            if (!string.startsWith("TLS")) continue;
            linkedHashSet.add(string);
        }
        Set set = HttpSupport.getConfiguredProtocols();
        if (!set.isEmpty()) {
            linkedHashSet.retainAll(set);
        }
        if (!linkedHashSet.isEmpty()) {
            sSLSocket.setEnabledProtocols(linkedHashSet.toArray(new String[0]));
        }
    }

    private static Set getConfiguredProtocols() {
        Set<Object> set = configuredHttpsProtocols;
        if (set == null) {
            String string = HttpSupport.getProperty("https.protocols");
            set = StringUtils.isEmptyOrNull(string) ? Collections.emptySet() : new LinkedHashSet<String>(Arrays.asList(string.split("\\s*,\\s*")));
            configuredHttpsProtocols = set;
        }
        return set;
    }

    private static String getProperty(String string) {
        try {
            return SystemReader.getInstance().getProperty(string);
        }
        catch (SecurityException securityException) {
            LOG.warn(JGitText.get().failedReadHttpsProtocols, (Throwable)securityException);
            return null;
        }
    }

    public static int scanToken(String string, int n2) {
        int n3 = string.length();
        int n4 = n2;
        if (n4 < 0 || n4 > n3) {
            throw new IndexOutOfBoundsException();
        }
        block3: while (n4 < n3) {
            char c2 = string.charAt(n4);
            switch (c2) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '^': 
                case '_': 
                case '`': 
                case '|': 
                case '~': {
                    ++n4;
                    continue block3;
                }
            }
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                ++n4;
                continue;
            }
            return n4;
        }
        return n4;
    }

    private HttpSupport() {
    }
}

