/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public final class Hex {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private Hex() {
    }

    public static byte[] decode(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = Character.digit(string.charAt(i2), 16);
            int n4 = Character.digit(string.charAt(i2 + 1), 16);
            if (n3 == -1 || n4 == -1) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidHexString, string));
            }
            byArray[i2 / 2] = (byte)(n3 << 4 | n4);
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = HEX[n2 >>> 4];
            cArray[i2 * 2 + 1] = HEX[n2 & 0xF];
        }
        return new String(cArray);
    }
}

