/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.GitDateParser$1;
import org.eclipse.jgit.util.GitDateParser$ParseableSimpleDateFormat;
import org.eclipse.jgit.util.SystemReader;

public class GitDateParser {
    public static final Date NEVER = new Date(Long.MAX_VALUE);
    private static ThreadLocal formatCache = new GitDateParser$1();

    private static SimpleDateFormat getDateFormat(GitDateParser$ParseableSimpleDateFormat gitDateParser$ParseableSimpleDateFormat, Locale locale) {
        Map map = (Map)formatCache.get();
        HashMap hashMap = (HashMap)map.get(locale);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(locale, hashMap);
            return GitDateParser.getNewSimpleDateFormat(gitDateParser$ParseableSimpleDateFormat, locale, hashMap);
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)hashMap.get((Object)gitDateParser$ParseableSimpleDateFormat);
        if (simpleDateFormat != null) {
            return simpleDateFormat;
        }
        SimpleDateFormat simpleDateFormat2 = GitDateParser.getNewSimpleDateFormat(gitDateParser$ParseableSimpleDateFormat, locale, hashMap);
        return simpleDateFormat2;
    }

    private static SimpleDateFormat getNewSimpleDateFormat(GitDateParser$ParseableSimpleDateFormat gitDateParser$ParseableSimpleDateFormat, Locale locale, Map map) {
        SimpleDateFormat simpleDateFormat = SystemReader.getInstance().getSimpleDateFormat(GitDateParser$ParseableSimpleDateFormat.access$000(gitDateParser$ParseableSimpleDateFormat), locale);
        map.put(gitDateParser$ParseableSimpleDateFormat, simpleDateFormat);
        return simpleDateFormat;
    }

    public static Date parse(String string, Calendar calendar) {
        return GitDateParser.parse(string, calendar, Locale.getDefault());
    }

    public static Date parse(String string, Calendar calendar, Locale locale) {
        if ("never".equalsIgnoreCase(string = string.trim())) {
            return NEVER;
        }
        Date date = GitDateParser.parse_relative(string, calendar);
        if (date != null) {
            return date;
        }
        for (GitDateParser$ParseableSimpleDateFormat gitDateParser$ParseableSimpleDateFormat : GitDateParser$ParseableSimpleDateFormat.values()) {
            try {
                return GitDateParser.parse_simple(string, gitDateParser$ParseableSimpleDateFormat, locale);
            }
            catch (ParseException parseException) {
            }
        }
        GitDateParser$ParseableSimpleDateFormat[] gitDateParser$ParseableSimpleDateFormatArray = GitDateParser$ParseableSimpleDateFormat.values();
        StringBuilder stringBuilder = new StringBuilder("\"").append(GitDateParser$ParseableSimpleDateFormat.access$000(gitDateParser$ParseableSimpleDateFormatArray[0]));
        for (int i2 = 1; i2 < gitDateParser$ParseableSimpleDateFormatArray.length; ++i2) {
            stringBuilder.append("\", \"").append(GitDateParser$ParseableSimpleDateFormat.access$000(gitDateParser$ParseableSimpleDateFormatArray[i2]));
        }
        stringBuilder.append("\"");
        throw new ParseException(MessageFormat.format(JGitText.get().cannotParseDate, string, stringBuilder.toString()), 0);
    }

    private static Date parse_simple(String string, GitDateParser$ParseableSimpleDateFormat gitDateParser$ParseableSimpleDateFormat, Locale locale) {
        SimpleDateFormat simpleDateFormat = GitDateParser.getDateFormat(gitDateParser$ParseableSimpleDateFormat, locale);
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.parse(string);
    }

    private static Date parse_relative(String string, Calendar calendar) {
        Calendar calendar2;
        SystemReader systemReader = SystemReader.getInstance();
        if ("now".equals(string)) {
            return calendar == null ? new Date(systemReader.getCurrentTime()) : calendar.getTime();
        }
        if (calendar == null) {
            calendar2 = new GregorianCalendar(systemReader.getTimeZone(), systemReader.getLocale());
            calendar2.setTimeInMillis(systemReader.getCurrentTime());
        } else {
            calendar2 = (Calendar)calendar.clone();
        }
        if ("yesterday".equals(string)) {
            calendar2.add(5, -1);
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
            calendar2.set(14, 0);
            return calendar2.getTime();
        }
        String[] stringArray = string.split("\\.| ");
        int n2 = stringArray.length;
        if (n2 < 3 || (n2 & 1) == 0 || !"ago".equals(stringArray[stringArray.length - 1])) {
            return null;
        }
        block27: for (int i2 = 0; i2 < stringArray.length - 2; i2 += 2) {
            int n3;
            try {
                n3 = Integer.parseInt(stringArray[i2]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (stringArray[i2 + 1] == null) {
                return null;
            }
            switch (stringArray[i2 + 1]) {
                case "year": 
                case "years": {
                    calendar2.add(1, -n3);
                    continue block27;
                }
                case "month": 
                case "months": {
                    calendar2.add(2, -n3);
                    continue block27;
                }
                case "week": 
                case "weeks": {
                    calendar2.add(3, -n3);
                    continue block27;
                }
                case "day": 
                case "days": {
                    calendar2.add(5, -n3);
                    continue block27;
                }
                case "hour": 
                case "hours": {
                    calendar2.add(11, -n3);
                    continue block27;
                }
                case "minute": 
                case "minutes": {
                    calendar2.add(12, -n3);
                    continue block27;
                }
                case "second": 
                case "seconds": {
                    calendar2.add(13, -n3);
                    continue block27;
                }
                default: {
                    return null;
                }
            }
        }
        return calendar2.getTime();
    }
}

