/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.GitDateFormatter$Format;
import org.eclipse.jgit.util.RelativeDateFormatter;
import org.eclipse.jgit.util.SystemReader;

public class GitDateFormatter {
    private DateFormat dateTimeInstance;
    private DateFormat dateTimeInstance2;
    private final GitDateFormatter$Format format;

    public GitDateFormatter(GitDateFormatter$Format gitDateFormatter$Format) {
        this.format = gitDateFormatter$Format;
        switch (gitDateFormatter$Format) {
            default: {
                break;
            }
            case DEFAULT: {
                this.dateTimeInstance = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z", Locale.US);
                break;
            }
            case ISO: {
                this.dateTimeInstance = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US);
                break;
            }
            case LOCAL: {
                this.dateTimeInstance = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
                break;
            }
            case RFC: {
                this.dateTimeInstance = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                break;
            }
            case SHORT: {
                this.dateTimeInstance = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                break;
            }
            case LOCALE: 
            case LOCALELOCAL: {
                SystemReader systemReader = SystemReader.getInstance();
                this.dateTimeInstance = systemReader.getDateTimeInstance(2, 2);
                this.dateTimeInstance2 = systemReader.getSimpleDateFormat("Z");
            }
        }
    }

    public String formatDate(PersonIdent personIdent) {
        switch (this.format) {
            case RAW: {
                int n2 = personIdent.getTimeZoneOffset();
                String string = n2 < 0 ? "-" : "+";
                int n3 = n2 < 0 ? -n2 : n2;
                int n4 = n3 / 60;
                int n5 = n3 % 60;
                return String.format("%d %s%02d%02d", personIdent.getWhen().getTime() / 1000L, string, n4, n5);
            }
            case RELATIVE: {
                return RelativeDateFormatter.format(personIdent.getWhen());
            }
            case LOCAL: 
            case LOCALELOCAL: {
                this.dateTimeInstance.setTimeZone(SystemReader.getInstance().getTimeZone());
                return this.dateTimeInstance.format(personIdent.getWhen());
            }
            case LOCALE: {
                TimeZone timeZone = personIdent.getTimeZone();
                if (timeZone == null) {
                    timeZone = SystemReader.getInstance().getTimeZone();
                }
                this.dateTimeInstance.setTimeZone(timeZone);
                this.dateTimeInstance2.setTimeZone(timeZone);
                return this.dateTimeInstance.format(personIdent.getWhen()) + " " + this.dateTimeInstance2.format(personIdent.getWhen());
            }
        }
        TimeZone timeZone = personIdent.getTimeZone();
        if (timeZone == null) {
            timeZone = SystemReader.getInstance().getTimeZone();
        }
        this.dateTimeInstance.setTimeZone(personIdent.getTimeZone());
        return this.dateTimeInstance.format(personIdent.getWhen());
    }
}

