/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$Attributes;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static final Random RNG = new Random();
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;
    public static final int IGNORE_ERRORS = 8;
    public static final int EMPTY_DIRECTORIES_ONLY = 16;

    public static Path toPath(File file) {
        try {
            return file.toPath();
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException(invalidPathException);
        }
    }

    public static void delete(File file) {
        FileUtils.delete(file, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void delete(File file, int n2) {
        Iterable<Path> iterable;
        Serializable serializable;
        File[] fileArray;
        FS fS = FS.DETECTED;
        if ((n2 & 4) != 0 && !fS.exists(file)) {
            return;
        }
        if ((n2 & 1) != 0 && fS.isDirectory(file) && (fileArray = file.listFiles()) != null) {
            serializable = new ArrayList();
            iterable = new ArrayList();
            for (File file2 : fileArray) {
                if (file2.isFile()) {
                    serializable.add(file2);
                    continue;
                }
                iterable.add((File)file2);
            }
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                File file3 = (File)iterator.next();
                FileUtils.delete(file3, n2);
            }
            for (File file4 : iterable) {
                FileUtils.delete(file4, n2);
            }
        }
        boolean bl2 = false;
        if ((n2 & 0x10) != 0) {
            if (file.isDirectory()) {
                bl2 = true;
            } else if ((n2 & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, file.getAbsolutePath()));
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            serializable = null;
            iterable = file.toPath();
            while (true) {
                boolean bl3 = false;
                try {
                    Files.delete((Path)iterable);
                    return;
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    FileUtils.handleDeleteException(file, iOException, n2, 12);
                    return;
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                    FileUtils.handleDeleteException(file, directoryNotEmptyException, n2, 8);
                    return;
                }
                catch (IOException iOException) {
                    if (!file.canWrite()) {
                        bl3 = file.setWritable(true);
                    }
                    if (bl3) continue;
                    serializable = iOException;
                    if (bl3) continue;
                    if ((n2 & 2) != 0) {
                        void var7_16;
                        boolean i2 = true;
                        while (var7_16 < 10) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException iOException2) {
                                // empty catch block
                            }
                            try {
                                Files.deleteIfExists(iterable);
                                return;
                            }
                            catch (IOException iOException2) {
                                serializable = iOException2;
                                ++var7_16;
                            }
                        }
                    }
                    FileUtils.handleDeleteException(file, (IOException)serializable, n2, 8);
                }
                break;
            }
        }
    }

    private static void handleDeleteException(File file, IOException iOException, int n2, int n3) {
        if (iOException != null && (n2 & n3) == 0) {
            throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, file.getAbsolutePath()), iOException);
        }
    }

    public static void rename(File file, File file2) {
        FileUtils.rename(file, file2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void rename(File file, File file2, CopyOption ... copyOptionArray) {
        int n2;
        int n3 = n2 = FS.DETECTED.retryFailedLockFileCommit() ? 10 : 1;
        while (--n2 >= 0) {
            try {
                Files.move(FileUtils.toPath(file), FileUtils.toPath(file2), copyOptionArray);
                return;
            }
            catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
                throw atomicMoveNotSupportedException;
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException(invalidPathException);
            }
            catch (IOException iOException) {
                try {
                    if (!file2.delete()) {
                        FileUtils.delete(file2, 17);
                    }
                    Files.move(FileUtils.toPath(file), FileUtils.toPath(file2), copyOptionArray);
                    return;
                }
                catch (IOException iOException2) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, file.getAbsolutePath(), file2.getAbsolutePath()), interruptedException);
                    }
                }
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, file.getAbsolutePath(), file2.getAbsolutePath()));
    }

    public static void mkdir(File file) {
        FileUtils.mkdir(file, false);
    }

    public static void mkdir(File file, boolean bl2) {
        if (!file.mkdir()) {
            if (bl2 && file.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirFailed, file.getAbsolutePath()));
        }
    }

    public static void mkdirs(File file) {
        FileUtils.mkdirs(file, false);
    }

    public static void mkdirs(File file, boolean bl2) {
        if (!file.mkdirs()) {
            if (bl2 && file.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirsFailed, file.getAbsolutePath()));
        }
    }

    public static void createNewFile(File file) {
        if (!file.createNewFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().createNewFileFailed, file));
        }
    }

    public static Path createSymLink(File file, String string) {
        Object object;
        Path path = FileUtils.toPath(file);
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            object = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (object.isRegularFile() || object.isSymbolicLink()) {
                FileUtils.delete(file);
            } else {
                FileUtils.delete(file, 17);
            }
        }
        if (SystemReader.getInstance().isWindows()) {
            string = string.replace('/', '\\');
        }
        object = FileUtils.toPath(new File(string));
        return Files.createSymbolicLink(path, (Path)object, new FileAttribute[0]);
    }

    public static String readSymLink(File file) {
        Path path = FileUtils.toPath(file);
        Path path2 = Files.readSymbolicLink(path);
        String string = path2.toString();
        if (SystemReader.getInstance().isWindows()) {
            string = string.replace('\\', '/');
        } else if (SystemReader.getInstance().isMacOS()) {
            string = Normalizer.normalize(string, Normalizer.Form.NFC);
        }
        return string;
    }

    public static File createTempDir(String string, String string2, File file) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < 1; ++i2) {
            File file2 = File.createTempFile(string, string2, file);
            if (!file2.delete() || !file2.mkdir()) continue;
            return file2;
        }
        throw new IOException(JGitText.get().cannotCreateTempDir);
    }

    public static String relativizeNativePath(String string, String string2) {
        return FS.DETECTED.relativize(string, string2);
    }

    public static String relativizeGitPath(String string, String string2) {
        return FileUtils.relativizePath(string, string2, "/", false);
    }

    public static String relativizePath(String string, String string2, String string3, boolean bl2) {
        int n2;
        if (string.equals(string2)) {
            return "";
        }
        String[] stringArray = string.split(Pattern.quote(string3));
        String[] stringArray2 = string2.split(Pattern.quote(string3));
        int n3 = 0;
        while (n3 < stringArray.length && n3 < stringArray2.length) {
            if (bl2 && stringArray[n3].equals(stringArray2[n3])) {
                ++n3;
                continue;
            }
            if (bl2 || !stringArray[n3].equalsIgnoreCase(stringArray2[n3])) break;
            ++n3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = n3; n2 < stringArray.length; ++n2) {
            stringBuilder.append("..").append(string3);
        }
        for (n2 = n3; n2 < stringArray2.length; ++n2) {
            stringBuilder.append(stringArray2[n2]);
            if (n2 >= stringArray2.length - 1) continue;
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static boolean isStaleFileHandle(IOException iOException) {
        String string = iOException.getMessage();
        return string != null && string.toLowerCase(Locale.ROOT).matches("stale .*file .*handle");
    }

    public static boolean isStaleFileHandleInCausalChain(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof IOException && FileUtils.isStaleFileHandle((IOException)throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    static boolean isSymlink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    @Deprecated
    static long lastModified(File file) {
        try {
            return Files.getLastModifiedTime(FileUtils.toPath(file), LinkOption.NOFOLLOW_LINKS).toMillis();
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException(invalidPathException);
        }
    }

    static Instant lastModifiedInstant(Path path) {
        try {
            return Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS).toInstant();
        }
        catch (NoSuchFileException noSuchFileException) {
            LOG.debug("Cannot read lastModifiedInstant since path {} does not exist", (Object)path);
            return Instant.EPOCH;
        }
        catch (IOException iOException) {
            LOG.error(MessageFormat.format(JGitText.get().readLastModifiedFailed, path), (Throwable)iOException);
            return Instant.ofEpochMilli(path.toFile().lastModified());
        }
    }

    static BasicFileAttributes fileAttributes(File file) {
        return Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    @Deprecated
    static void setLastModified(File file, long l2) {
        Files.setLastModifiedTime(FileUtils.toPath(file), FileTime.fromMillis(l2));
    }

    static void setLastModified(Path path, Instant instant) {
        Files.setLastModifiedTime(path, FileTime.from(instant));
    }

    static boolean exists(File file) {
        return Files.exists(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    static boolean isHidden(File file) {
        return Files.isHidden(FileUtils.toPath(file));
    }

    public static void setHidden(File file, boolean bl2) {
        Files.setAttribute(FileUtils.toPath(file), "dos:hidden", bl2, LinkOption.NOFOLLOW_LINKS);
    }

    public static long getLength(File file) {
        Path path = FileUtils.toPath(file);
        if (Files.isSymbolicLink(path)) {
            return Files.readSymbolicLink(path).toString().getBytes(StandardCharsets.UTF_8).length;
        }
        return Files.size(path);
    }

    static boolean isDirectory(File file) {
        return Files.isDirectory(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    static boolean isFile(File file) {
        return Files.isRegularFile(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean hasFiles(Path path) {
        try (Stream<Path> stream = Files.list(path);){
            boolean bl2 = stream.findAny().isPresent();
            return bl2;
        }
    }

    public static boolean canExecute(File file) {
        if (!FileUtils.isFile(file)) {
            return false;
        }
        return Files.isExecutable(file.toPath());
    }

    static FS$Attributes getFileAttributesBasic(FS fS, File file) {
        try {
            Path path = FileUtils.toPath(file);
            BasicFileAttributes basicFileAttributes = path.getFileSystem().provider().getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            FS$Attributes fS$Attributes = new FS$Attributes(fS, file, true, basicFileAttributes.isDirectory(), fS.supportsExecute() ? file.canExecute() : false, basicFileAttributes.isSymbolicLink(), basicFileAttributes.isRegularFile(), basicFileAttributes.creationTime().toMillis(), basicFileAttributes.lastModifiedTime().toInstant(), basicFileAttributes.isSymbolicLink() ? (long)Constants.encode(FileUtils.readSymLink(file)).length : basicFileAttributes.size());
            return fS$Attributes;
        }
        catch (IOException iOException) {
            return new FS$Attributes(file, fS);
        }
    }

    public static FS$Attributes getFileAttributesPosix(FS fS, File file) {
        try {
            Path path = FileUtils.toPath(file);
            PosixFileAttributes posixFileAttributes = path.getFileSystem().provider().getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            FS$Attributes fS$Attributes = new FS$Attributes(fS, file, true, posixFileAttributes.isDirectory(), posixFileAttributes.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE), posixFileAttributes.isSymbolicLink(), posixFileAttributes.isRegularFile(), posixFileAttributes.creationTime().toMillis(), posixFileAttributes.lastModifiedTime().toInstant(), posixFileAttributes.size());
            return fS$Attributes;
        }
        catch (IOException iOException) {
            return new FS$Attributes(file, fS);
        }
    }

    public static File normalize(File file) {
        if (SystemReader.getInstance().isMacOS()) {
            String string = Normalizer.normalize(file.getPath(), Normalizer.Form.NFC);
            return new File(string);
        }
        return file;
    }

    public static String normalize(String string) {
        if (SystemReader.getInstance().isMacOS()) {
            if (string == null) {
                return null;
            }
            return Normalizer.normalize(string, Normalizer.Form.NFC);
        }
        return string;
    }

    public static File canonicalize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static String pathToString(File file) {
        String string = file.getPath();
        if (SystemReader.getInstance().isWindows()) {
            return string.replace('\\', '/');
        }
        return string;
    }

    public static void touch(Path path) {
        FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.SYNC);
        Throwable throwable = null;
        if (fileChannel != null) {
            if (throwable != null) {
                try {
                    fileChannel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                fileChannel.close();
            }
        }
        Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
    }

    public static long delay(long l2, long l3, long l4) {
        long l5 = Math.max(0L, l2 * 3L - l3);
        if (l5 > 0L) {
            int n2 = (int)Math.min(l5 + 1L, Integer.MAX_VALUE);
            l5 = RNG.nextInt(n2);
        }
        return Math.max(Math.min(l3 + l5, l4), l3);
    }
}

