/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_Win32_Cygwin
extends FS_Win32 {
    private static final Logger LOG = LoggerFactory.getLogger(FS_Win32_Cygwin.class);
    private static String cygpath;

    public static boolean isCygwin() {
        String string = AccessController.doPrivileged(() -> System.getProperty("java.library.path"));
        if (string == null) {
            return false;
        }
        File file = FS.searchPath(string, "cygpath.exe");
        if (file != null) {
            cygpath = file.getPath();
        }
        return cygpath != null;
    }

    public FS_Win32_Cygwin() {
    }

    protected FS_Win32_Cygwin(FS fS) {
        super(fS);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32_Cygwin(this);
    }

    @Override
    public File resolve(File file, String string) {
        String string2 = System.getProperty("jgit.usecygpath");
        if (string2 != null && string2.equals("true")) {
            String string3;
            try {
                string3 = FS_Win32_Cygwin.readPipe(file, new String[]{cygpath, "--windows", "--absolute", string}, StandardCharsets.UTF_8.name());
            }
            catch (CommandFailedException commandFailedException) {
                LOG.warn(commandFailedException.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(string3)) {
                return new File(string3);
            }
        }
        return super.resolve(file, string);
    }

    @Override
    protected File userHomeImpl() {
        String string = AccessController.doPrivileged(() -> System.getenv("HOME"));
        if (string == null || string.length() == 0) {
            return super.userHomeImpl();
        }
        return this.resolve(new File("."), string);
    }

    @Override
    public ProcessBuilder runInShell(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4 + stringArray.length);
        arrayList.add("sh.exe");
        arrayList.add("-c");
        arrayList.add(string + " \"$@\"");
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(stringArray));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(arrayList);
        return processBuilder;
    }

    @Override
    String shellQuote(String string) {
        return QuotedString.BOURNE.quote(string.replace(File.separatorChar, '/'));
    }

    @Override
    public String relativize(String string, String string2) {
        String string3 = super.relativize(string, string2);
        return string3.replace(File.separatorChar, '/');
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String string, String[] stringArray, OutputStream outputStream, OutputStream outputStream2, String string2) {
        return this.internalRunHookIfPresent(repository, string, stringArray, outputStream, outputStream2, string2);
    }
}

