/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.treewalk.FileTreeIterator$FileModeStrategy;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$Entry;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$Attributes;
import org.eclipse.jgit.util.FS_Win32$1;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_Win32
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_Win32.class);

    public FS_Win32() {
    }

    protected FS_Win32(FS fS) {
        super(fS);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32(this);
    }

    @Override
    public boolean supportsExecute() {
        return false;
    }

    @Override
    public boolean canExecute(File file) {
        return false;
    }

    @Override
    public boolean setExecute(File file, boolean bl2) {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return true;
    }

    @Override
    public WorkingTreeIterator$Entry[] list(File file, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        ArrayList arrayList = new ArrayList();
        FS_Win32 fS_Win32 = this;
        boolean bl2 = ((FS)fS_Win32).supportsExecute();
        try {
            Files.walkFileTree(file.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, new FS_Win32$1(this, fS_Win32, bl2, arrayList, fileTreeIterator$FileModeStrategy));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (arrayList.isEmpty()) {
            return NO_ENTRIES;
        }
        return arrayList.toArray(new WorkingTreeIterator$Entry[0]);
    }

    @Override
    protected File discoverGitExe() {
        String string = SystemReader.getInstance().getenv("PATH");
        File file = FS_Win32.searchPath(string, "git.exe", "git.cmd");
        if (file == null && FS_Win32.searchPath(string, "bash.exe") != null) {
            String string2;
            try {
                string2 = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            }
            catch (CommandFailedException commandFailedException) {
                LOG.warn(commandFailedException.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(string2)) {
                file = this.resolve(null, string2);
            }
        }
        return file;
    }

    @Override
    protected File userHomeImpl() {
        String string;
        String string2 = SystemReader.getInstance().getenv("HOME");
        if (string2 != null) {
            return this.resolve(null, string2);
        }
        String string3 = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (string3 != null && (string = SystemReader.getInstance().getenv("HOMEPATH")) != null) {
            return new File(string3, string);
        }
        string = SystemReader.getInstance().getenv("HOMESHARE");
        if (string != null) {
            return new File(string);
        }
        return super.userHomeImpl();
    }

    @Override
    public ProcessBuilder runInShell(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(3 + stringArray.length);
        arrayList.add("cmd.exe");
        arrayList.add("/c");
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(stringArray));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(arrayList);
        return processBuilder;
    }

    @Override
    public FS$Attributes getAttributes(File file) {
        return FileUtils.getFileAttributesBasic(this, file);
    }
}

