/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$Attributes;
import org.eclipse.jgit.util.FS$LockToken;
import org.eclipse.jgit.util.FS_POSIX$AtomicFileCreation;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_POSIX
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_POSIX.class);
    private static final String DEFAULT_GIT_LOCATION = "/usr/bin/git";
    private static final int DEFAULT_UMASK = 18;
    private volatile int umask = -1;
    private static final Map CAN_HARD_LINK = new ConcurrentHashMap();
    private volatile FS_POSIX$AtomicFileCreation supportsAtomicFileCreation = FS_POSIX$AtomicFileCreation.UNDEFINED;

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS fS) {
        super(fS);
        if (fS instanceof FS_POSIX) {
            this.umask = ((FS_POSIX)fS).umask;
        }
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX(this);
    }

    public void setUmask(int n2) {
        this.umask = n2;
    }

    private int umask() {
        int n2 = this.umask;
        if (n2 == -1) {
            this.umask = n2 = FS_POSIX.readUmask();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readUmask() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset().name()));){
                String string;
                if (process.waitFor() == 0 && (string = bufferedReader.readLine()) != null && string.matches("0?\\d{3}")) {
                    int n3 = Integer.parseInt(string, 8);
                    return n3;
                }
                int n2 = 18;
                return n2;
            }
        }
        catch (Exception exception) {
            return 18;
        }
    }

    @Override
    protected File discoverGitExe() {
        String string = SystemReader.getInstance().getenv("PATH");
        File file = FS_POSIX.searchPath(string, "git");
        if (SystemReader.getInstance().isMacOS()) {
            String string2;
            if ((file == null || DEFAULT_GIT_LOCATION.equals(file.getPath())) && FS_POSIX.searchPath(string, "bash") != null) {
                try {
                    string2 = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
                    if (!StringUtils.isEmptyOrNull(string2)) {
                        file = new File(string2);
                    }
                }
                catch (CommandFailedException commandFailedException) {
                    LOG.warn(commandFailedException.getMessage());
                }
            }
            if (file != null && DEFAULT_GIT_LOCATION.equals(file.getPath())) {
                try {
                    string2 = FS_POSIX.readPipe(this.userHome(), new String[]{"xcode-select", "-p"}, Charset.defaultCharset().name());
                    if (StringUtils.isEmptyOrNull(string2)) {
                        file = null;
                    } else {
                        File file2 = new File(new File(string2), DEFAULT_GIT_LOCATION.substring(1));
                        if (!file2.exists()) {
                            file = null;
                        }
                    }
                }
                catch (CommandFailedException commandFailedException) {
                    file = null;
                }
            }
        }
        return file;
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File file) {
        return FileUtils.canExecute(file);
    }

    @Override
    public boolean setExecute(File file, boolean bl2) {
        if (!this.isFile(file)) {
            return false;
        }
        if (!bl2) {
            return file.setExecutable(false, false);
        }
        try {
            Path path = FileUtils.toPath(file);
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
            set.add(PosixFilePermission.OWNER_EXECUTE);
            int n2 = this.umask();
            FS_POSIX.apply(set, n2, PosixFilePermission.GROUP_EXECUTE, 8);
            FS_POSIX.apply(set, n2, PosixFilePermission.OTHERS_EXECUTE, 1);
            Files.setPosixFilePermissions(path, set);
            return true;
        }
        catch (IOException iOException) {
            boolean bl3 = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
            if (bl3) {
                System.err.println(iOException);
            }
            return false;
        }
    }

    private static void apply(Set set, int n2, PosixFilePermission posixFilePermission, int n3) {
        if ((n2 & n3) == 0) {
            set.add(posixFilePermission);
        } else {
            set.remove((Object)posixFilePermission);
        }
    }

    @Override
    public ProcessBuilder runInShell(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4 + stringArray.length);
        arrayList.add("sh");
        arrayList.add("-c");
        arrayList.add(string + " \"$@\"");
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(stringArray));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(arrayList);
        return processBuilder;
    }

    @Override
    String shellQuote(String string) {
        return QuotedString.BOURNE.quote(string);
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String string, String[] stringArray, OutputStream outputStream, OutputStream outputStream2, String string2) {
        return this.internalRunHookIfPresent(repository, string, stringArray, outputStream, outputStream2, string2);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public void setHidden(File file, boolean bl2) {
    }

    @Override
    public FS$Attributes getAttributes(File file) {
        return FileUtils.getFileAttributesPosix(this, file);
    }

    @Override
    public File normalize(File file) {
        return FileUtils.normalize(file);
    }

    @Override
    public String normalize(String string) {
        return FileUtils.normalize(string);
    }

    @Override
    public boolean supportsAtomicCreateNewFile() {
        if (this.supportsAtomicFileCreation == FS_POSIX$AtomicFileCreation.UNDEFINED) {
            try {
                StoredConfig storedConfig = SystemReader.getInstance().getUserConfig(this);
                String string = storedConfig.getString("core", null, "supportsatomicfilecreation");
                this.supportsAtomicFileCreation = string != null ? (StringUtils.toBoolean(string) ? FS_POSIX$AtomicFileCreation.SUPPORTED : FS_POSIX$AtomicFileCreation.NOT_SUPPORTED) : FS_POSIX$AtomicFileCreation.SUPPORTED;
            }
            catch (IOException | ConfigInvalidException exception) {
                LOG.warn(JGitText.get().assumeAtomicCreateNewFile, (Throwable)exception);
                this.supportsAtomicFileCreation = FS_POSIX$AtomicFileCreation.SUPPORTED;
            }
        }
        return this.supportsAtomicFileCreation == FS_POSIX$AtomicFileCreation.SUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public boolean createNewFile(File file) {
        boolean bl2;
        Path path;
        block16: {
            boolean bl3;
            block15: {
                if (!file.createNewFile()) {
                    return false;
                }
                if (this.supportsAtomicCreateNewFile()) {
                    return true;
                }
                Path path2 = file.toPath();
                path = null;
                FileStore fileStore2 = null;
                try {
                    fileStore2 = Files.getFileStore(path2);
                }
                catch (SecurityException securityException) {
                    return true;
                }
                try {
                    Boolean bl4 = CAN_HARD_LINK.computeIfAbsent(fileStore2, fileStore -> Boolean.TRUE);
                    if (Boolean.FALSE.equals(bl4)) {
                        boolean bl5 = true;
                        return bl5;
                    }
                    path = Files.createLink(Paths.get(file.getAbsolutePath() + ".lnk", new String[0]), path2);
                    Integer n2 = (Integer)Files.getAttribute(path2, "unix:nlink", new LinkOption[0]);
                    if (n2 > 2) {
                        LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, path2, n2));
                        bl3 = false;
                        if (path == null) return bl3;
                        break block15;
                    }
                    if (n2 < 2) {
                        CAN_HARD_LINK.put(fileStore2, Boolean.FALSE);
                    }
                    bl2 = true;
                    if (path == null) return bl2;
                    break block16;
                }
                catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                    CAN_HARD_LINK.put(fileStore2, Boolean.FALSE);
                    boolean bl6 = true;
                    return bl6;
                }
            }
            Files.delete(path);
            return bl3;
        }
        Files.delete(path);
        return bl2;
        finally {
            if (path != null) {
                Files.delete(path);
            }
        }
    }

    @Override
    public FS$LockToken createNewFileAtomic(File file) {
        Path path;
        try {
            path = file.toPath();
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException | InvalidPathException exception) {
            return FS_POSIX.token(false, null);
        }
        if (this.supportsAtomicCreateNewFile()) {
            return FS_POSIX.token(true, null);
        }
        Path path2 = null;
        FileStore fileStore2 = null;
        try {
            fileStore2 = Files.getFileStore(path);
        }
        catch (SecurityException securityException) {
            return FS_POSIX.token(true, null);
        }
        try {
            Boolean bl2 = CAN_HARD_LINK.computeIfAbsent(fileStore2, fileStore -> Boolean.TRUE);
            if (Boolean.FALSE.equals(bl2)) {
                return FS_POSIX.token(true, null);
            }
            path2 = Files.createLink(Paths.get(FS_POSIX.uniqueLinkPath(file), new String[0]), path);
            Integer n2 = (Integer)Files.getAttribute(path, "unix:nlink", new LinkOption[0]);
            if (n2 > 2) {
                LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, path, n2));
                return FS_POSIX.token(false, path2);
            }
            if (n2 < 2) {
                CAN_HARD_LINK.put(fileStore2, Boolean.FALSE);
            }
            return FS_POSIX.token(true, path2);
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException | FileSystemException exception) {
            CAN_HARD_LINK.put(fileStore2, Boolean.FALSE);
            return FS_POSIX.token(true, path2);
        }
    }

    private static FS$LockToken token(boolean bl2, @Nullable Path path) {
        return path != null && Files.exists(path, new LinkOption[0]) ? new FS$LockToken(bl2, Optional.of(path)) : new FS$LockToken(bl2, Optional.empty());
    }

    private static String uniqueLinkPath(File file) {
        UUID uUID = UUID.randomUUID();
        return file.getAbsolutePath() + "." + Long.toHexString(uUID.getMostSignificantBits()) + Long.toHexString(uUID.getLeastSignificantBits());
    }
}

