/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.treewalk.FileTreeIterator$FileEntry;
import org.eclipse.jgit.treewalk.FileTreeIterator$FileModeStrategy;
import org.eclipse.jgit.treewalk.WorkingTreeIterator$Entry;
import org.eclipse.jgit.util.FS$Attributes;
import org.eclipse.jgit.util.FS$ExecutionResult;
import org.eclipse.jgit.util.FS$FSFactory;
import org.eclipse.jgit.util.FS$FileStoreAttributes;
import org.eclipse.jgit.util.FS$GobblerThread;
import org.eclipse.jgit.util.FS$Holder;
import org.eclipse.jgit.util.FS$LockToken;
import org.eclipse.jgit.util.FS$StreamGobbler;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.ProcessResult$Status;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS.class);
    public static boolean DISALLOW_READ_PIPE = "true".equals(System.getProperty("jgit.fs.disallowReadPipe"));
    protected static final WorkingTreeIterator$Entry[] NO_ENTRIES = new WorkingTreeIterator$Entry[0];
    private static final Pattern VERSION = Pattern.compile("\\s(\\d+)\\.(\\d+)\\.(\\d+)");
    private volatile Boolean supportSymlinks;
    public static final FS DETECTED = FS.detect();
    private static volatile FS$FSFactory factory;
    private volatile FS$Holder userHome;
    private volatile FS$Holder gitSystemConfig;

    public static FS detect() {
        return FS.detect(null);
    }

    @Deprecated
    public static void setAsyncFileStoreAttributes(boolean bl2) {
        FS$FileStoreAttributes.setBackground(bl2);
    }

    public static FS detect(Boolean bl2) {
        if (factory == null) {
            factory = new FS$FSFactory();
        }
        return factory.detect(bl2);
    }

    public static FS$FileStoreAttributes getFileStoreAttributes(@NonNull Path path, FS fS) {
        return FS$FileStoreAttributes.get(path, fS);
    }

    protected FS() {
    }

    protected FS(FS fS) {
        this.userHome = fS.userHome;
        this.gitSystemConfig = fS.gitSystemConfig;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public boolean supportsAtomicCreateNewFile() {
        return true;
    }

    public boolean supportsSymlinks() {
        if (this.supportSymlinks == null) {
            this.detectSymlinkSupport();
        }
        return Boolean.TRUE.equals(this.supportSymlinks);
    }

    private void detectSymlinkSupport() {
        File file = null;
        try {
            file = File.createTempFile("tempsymlinktarget", "");
            File file2 = new File(file.getParentFile(), "tempsymlink");
            this.createSymLink(file2, file.getPath());
            this.supportSymlinks = Boolean.TRUE;
            file2.delete();
        }
        catch (IOException | InternalError | SecurityException | UnsupportedOperationException throwable) {
            this.supportSymlinks = Boolean.FALSE;
        }
        finally {
            if (file != null) {
                try {
                    FileUtils.delete(file);
                }
                catch (IOException iOException) {
                    LOG.error(JGitText.get().cannotDeleteFile, (Object)file);
                }
            }
        }
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    @Deprecated
    public long lastModified(File file) {
        return FileUtils.lastModified(file);
    }

    public Instant lastModifiedInstant(Path path) {
        return FileUtils.lastModifiedInstant(path);
    }

    public Instant lastModifiedInstant(File file) {
        return FileUtils.lastModifiedInstant(file.toPath());
    }

    @Deprecated
    public void setLastModified(File file, long l2) {
        FileUtils.setLastModified(file, l2);
    }

    public void setLastModified(Path path, Instant instant) {
        FileUtils.setLastModified(path, instant);
    }

    public long length(File file) {
        return FileUtils.getLength(file);
    }

    public void delete(File file) {
        FileUtils.delete(file);
    }

    public File resolve(File file, String string) {
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        return new File(file, string);
    }

    public File userHome() {
        FS$Holder fS$Holder = this.userHome;
        if (fS$Holder == null) {
            this.userHome = fS$Holder = new FS$Holder(this.safeUserHomeImpl());
        }
        return (File)fS$Holder.value;
    }

    private File safeUserHomeImpl() {
        File file;
        try {
            file = this.userHomeImpl();
            if (file != null) {
                file.toPath();
                return file;
            }
        }
        catch (RuntimeException runtimeException) {
            LOG.error(JGitText.get().exceptionWhileFindingUserHome, (Throwable)runtimeException);
        }
        file = this.defaultUserHomeImpl();
        if (file != null) {
            try {
                file.toPath();
                return file;
            }
            catch (InvalidPathException invalidPathException) {
                LOG.error(MessageFormat.format(JGitText.get().invalidHomeDirectory, file), (Throwable)invalidPathException);
            }
        }
        return null;
    }

    public FS setUserHome(File file) {
        this.userHome = new FS$Holder(file);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    public BasicFileAttributes fileAttributes(File file) {
        return FileUtils.fileAttributes(file);
    }

    protected File userHomeImpl() {
        return this.defaultUserHomeImpl();
    }

    private File defaultUserHomeImpl() {
        String string = AccessController.doPrivileged(() -> System.getProperty("user.home"));
        if (string == null || string.length() == 0) {
            return null;
        }
        return new File(string).getAbsoluteFile();
    }

    protected static File searchPath(String string, String ... stringArray) {
        if (string == null) {
            return null;
        }
        for (String string2 : string.split(File.pathSeparator)) {
            for (String string3 : stringArray) {
                File file = new File(string2, string3);
                try {
                    if (!file.isFile() || !file.canExecute()) continue;
                    return file.getAbsoluteFile();
                }
                catch (SecurityException securityException) {
                    LOG.warn(MessageFormat.format(JGitText.get().skipNotAccessiblePath, file.getPath()));
                }
            }
        }
        return null;
    }

    @Nullable
    protected static String readPipe(File file, String[] stringArray, String string) {
        return FS.readPipe(file, stringArray, string, null);
    }

    @Nullable
    protected static String readPipe(File file, String[] stringArray, String string, Map map) {
        if (DISALLOW_READ_PIPE) {
            throw new InternalError();
        }
        boolean bl2 = LOG.isDebugEnabled();
        try {
            Process process;
            if (bl2) {
                LOG.debug("readpipe " + Arrays.asList(stringArray) + "," + file);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.directory(file);
            if (map != null) {
                processBuilder.environment().putAll(map);
            }
            try {
                process = processBuilder.start();
            }
            catch (IOException iOException) {
                throw new CommandFailedException(-1, iOException.getMessage(), iOException);
            }
            process.getOutputStream().close();
            FS$GobblerThread fS$GobblerThread = new FS$GobblerThread(process, stringArray, file);
            fS$GobblerThread.start();
            String string2 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), string));){
                string2 = bufferedReader.readLine();
                if (bl2) {
                    String string3;
                    LOG.debug("readpipe may return '" + string2 + "'");
                    LOG.debug("remaining output:\n");
                    while ((string3 = bufferedReader.readLine()) != null) {
                        LOG.debug(string3);
                    }
                }
            }
            while (true) {
                try {
                    int n2 = process.waitFor();
                    fS$GobblerThread.join();
                    if (n2 == 0 && !fS$GobblerThread.fail.get()) {
                        return string2;
                    }
                    if (bl2) {
                        LOG.debug("readpipe rc=" + n2);
                    }
                    throw new CommandFailedException(n2, (String)fS$GobblerThread.errorMessage.get(), (Throwable)fS$GobblerThread.exception.get());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            LOG.error("Caught exception in FS.readPipe()", (Throwable)iOException);
        }
        catch (AccessControlException accessControlException) {
            LOG.warn(MessageFormat.format(JGitText.get().readPipeIsNotAllowedRequiredPermission, stringArray, file, accessControlException.getPermission()));
        }
        catch (SecurityException securityException) {
            LOG.warn(MessageFormat.format(JGitText.get().readPipeIsNotAllowed, stringArray, file));
        }
        if (bl2) {
            LOG.debug("readpipe returns null");
        }
        return null;
    }

    protected abstract File discoverGitExe();

    protected File discoverGitSystemConfig() {
        String string;
        String string2;
        File file = this.discoverGitExe();
        if (file == null) {
            return null;
        }
        try {
            string2 = FS.readPipe(file.getParentFile(), new String[]{file.getPath(), "--version"}, Charset.defaultCharset().name());
        }
        catch (CommandFailedException commandFailedException) {
            LOG.warn(commandFailedException.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(string2) || string2 != null && string2.startsWith("jgit")) {
            return null;
        }
        if (this.parseVersion(string2) < this.makeVersion(2, 8, 0)) {
            String string3;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GIT_EDITOR", "echo");
            try {
                string3 = FS.readPipe(file.getParentFile(), new String[]{file.getPath(), "config", "--system", "--edit"}, Charset.defaultCharset().name(), hashMap);
            }
            catch (CommandFailedException commandFailedException) {
                LOG.warn(commandFailedException.getMessage());
                return null;
            }
            if (StringUtils.isEmptyOrNull(string3)) {
                return null;
            }
            return new File(string3);
        }
        try {
            string = FS.readPipe(file.getParentFile(), new String[]{file.getPath(), "config", "--system", "--show-origin", "--list", "-z"}, Charset.defaultCharset().name());
        }
        catch (CommandFailedException commandFailedException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(commandFailedException.getMessage());
            }
            return null;
        }
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(0);
        if (n2 <= 0) {
            return null;
        }
        int n3 = (string = string.substring(0, n2)).indexOf(58);
        if (n3 < 0) {
            return null;
        }
        return (string = string.substring(n3 + 1)).isEmpty() ? null : new File(string);
    }

    private long parseVersion(String string) {
        Matcher matcher = VERSION.matcher(string);
        if (matcher.find()) {
            try {
                return this.makeVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private long makeVersion(int n2, int n3, int n4) {
        return ((long)n2 * 10000L + (long)n3) * 10000L + (long)n4;
    }

    public File getGitSystemConfig() {
        if (this.gitSystemConfig == null) {
            this.gitSystemConfig = new FS$Holder(this.discoverGitSystemConfig());
        }
        return (File)this.gitSystemConfig.value;
    }

    public FS setGitSystemConfig(File file) {
        this.gitSystemConfig = new FS$Holder(file);
        return this;
    }

    protected static File resolveGrandparentFile(File file) {
        File file2;
        if (file != null && (file2 = file.getParentFile()) != null) {
            return file2.getParentFile();
        }
        return null;
    }

    public String readSymLink(File file) {
        return FileUtils.readSymLink(file);
    }

    public boolean isSymLink(File file) {
        return FileUtils.isSymlink(file);
    }

    public boolean exists(File file) {
        return FileUtils.exists(file);
    }

    public boolean isDirectory(File file) {
        return FileUtils.isDirectory(file);
    }

    public boolean isFile(File file) {
        return FileUtils.isFile(file);
    }

    public boolean isHidden(File file) {
        return FileUtils.isHidden(file);
    }

    public void setHidden(File file, boolean bl2) {
        FileUtils.setHidden(file, bl2);
    }

    public void createSymLink(File file, String string) {
        FileUtils.createSymLink(file, string);
    }

    @Deprecated
    public boolean createNewFile(File file) {
        return file.createNewFile();
    }

    public FS$LockToken createNewFileAtomic(File file) {
        return new FS$LockToken(file.createNewFile(), Optional.empty());
    }

    public String relativize(String string, String string2) {
        return FileUtils.relativizePath(string, string2, File.separator, this.isCaseSensitive());
    }

    public WorkingTreeIterator$Entry[] list(File file, FileTreeIterator$FileModeStrategy fileTreeIterator$FileModeStrategy) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return NO_ENTRIES;
        }
        WorkingTreeIterator$Entry[] workingTreeIterator$EntryArray = new WorkingTreeIterator$Entry[fileArray.length];
        for (int i2 = 0; i2 < workingTreeIterator$EntryArray.length; ++i2) {
            workingTreeIterator$EntryArray[i2] = new FileTreeIterator$FileEntry(fileArray[i2], this, fileTreeIterator$FileModeStrategy);
        }
        return workingTreeIterator$EntryArray;
    }

    public ProcessResult runHookIfPresent(Repository repository, String string, String[] stringArray) {
        return this.runHookIfPresent(repository, string, stringArray, System.out, System.err, null);
    }

    public ProcessResult runHookIfPresent(Repository repository, String string, String[] stringArray, OutputStream outputStream, OutputStream outputStream2, String string2) {
        return new ProcessResult(ProcessResult$Status.NOT_SUPPORTED);
    }

    protected ProcessResult internalRunHookIfPresent(Repository repository, String string, String[] stringArray, OutputStream outputStream, OutputStream outputStream2, String string2) {
        File file = this.findHook(repository, string);
        if (file == null || string == null) {
            return new ProcessResult(ProcessResult$Status.NOT_PRESENT);
        }
        File file2 = this.getRunDirectory(repository, string);
        if (file2 == null) {
            return new ProcessResult(ProcessResult$Status.NOT_PRESENT);
        }
        String string3 = file.getAbsolutePath();
        ProcessBuilder processBuilder = this.runInShell(this.shellQuote(string3), stringArray);
        processBuilder.directory(file2.getAbsoluteFile());
        Map<String, String> map = processBuilder.environment();
        map.put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        if (!repository.isBare()) {
            map.put("GIT_WORK_TREE", repository.getWorkTree().getAbsolutePath());
        }
        try {
            return new ProcessResult(this.runProcess(processBuilder, outputStream, outputStream2, string2), ProcessResult$Status.OK);
        }
        catch (IOException iOException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfHook, string), iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionHookExecutionInterrupted, string), interruptedException);
        }
    }

    String shellQuote(String string) {
        return string;
    }

    public File findHook(Repository repository, String string) {
        if (string == null) {
            return null;
        }
        File file = this.getHooksDirectory(repository);
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string);
        if (file2.isAbsolute()) {
            if (!file2.exists() || DETECTED.supportsExecute() && !DETECTED.canExecute(file2)) {
                return null;
            }
        } else {
            try {
                File file3 = this.getRunDirectory(repository, string);
                if (file3 == null) {
                    return null;
                }
                Path path = file3.getAbsoluteFile().toPath().resolve(file2.toPath());
                FS fS = repository.getFS();
                if (fS == null) {
                    fS = DETECTED;
                }
                if (!Files.exists(path, new LinkOption[0]) || fS.supportsExecute() && !fS.canExecute(path.toFile())) {
                    return null;
                }
                file2 = path.toFile();
            }
            catch (InvalidPathException invalidPathException) {
                LOG.warn(MessageFormat.format(JGitText.get().invalidHooksPath, file2));
                return null;
            }
        }
        return file2;
    }

    private File getRunDirectory(Repository repository, @NonNull String string) {
        if (repository.isBare()) {
            return repository.getDirectory();
        }
        switch (string) {
            case "pre-receive": 
            case "update": 
            case "post-receive": 
            case "post-update": 
            case "push-to-checkout": {
                return repository.getDirectory();
            }
        }
        return repository.getWorkTree();
    }

    private File getHooksDirectory(Repository repository) {
        StoredConfig storedConfig = repository.getConfig();
        String string = storedConfig.getString("core", null, "hooksPath");
        if (string != null) {
            return new File(string);
        }
        return repository.getDirectoryChild("hooks");
    }

    public int runProcess(ProcessBuilder processBuilder, OutputStream outputStream, OutputStream outputStream2, String string) {
        ByteArrayInputStream byteArrayInputStream = string == null ? null : new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        return this.runProcess(processBuilder, outputStream, outputStream2, byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(ProcessBuilder processBuilder, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream) {
        IOException iOException;
        block42: {
            int n2;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Process process = null;
            iOException = null;
            try {
                process = processBuilder.start();
                executorService.execute(new FS$StreamGobbler(process.getErrorStream(), outputStream2));
                executorService.execute(new FS$StreamGobbler(process.getInputStream(), outputStream));
                OutputStream outputStream3 = process.getOutputStream();
                try {
                    if (inputStream != null) {
                        new FS$StreamGobbler(inputStream, outputStream3).copy();
                    }
                }
                finally {
                    try {
                        outputStream3.close();
                    }
                    catch (IOException iOException2) {}
                }
                n2 = process.waitFor();
            }
            catch (IOException iOException3) {
                try {
                    iOException = iOException3;
                }
                catch (Throwable throwable) {
                    FS.shutdownAndAwaitTermination(executorService);
                    if (process != null) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException iOException4) {
                            iOException = iOException != null ? iOException : iOException4;
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException iOException5) {
                            iOException = iOException != null ? iOException : iOException5;
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException iOException6) {
                            iOException = iOException != null ? iOException : iOException6;
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                FS.shutdownAndAwaitTermination(executorService);
                if (process == null) break block42;
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException7) {
                    iOException = iOException != null ? iOException : iOException7;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException iOException8) {
                    iOException = iOException != null ? iOException : iOException8;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException9) {
                    iOException = iOException != null ? iOException : iOException9;
                }
                process.destroy();
            }
            FS.shutdownAndAwaitTermination(executorService);
            if (process != null) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException10) {
                    iOException = iOException != null ? iOException : iOException10;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException iOException11) {
                    iOException = iOException != null ? iOException : iOException11;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException12) {
                    iOException = iOException != null ? iOException : iOException12;
                }
                process.destroy();
            }
            return n2;
        }
        throw iOException;
    }

    private static boolean shutdownAndAwaitTermination(ExecutorService executorService) {
        boolean bl2 = true;
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    bl2 = false;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
            bl2 = false;
        }
        return bl2;
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    /*
     * Exception decompiling
     */
    public FS$ExecutionResult execute(ProcessBuilder var1_1, InputStream var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FS$Attributes getAttributes(File file) {
        boolean bl2;
        boolean bl3 = this.isDirectory(file);
        boolean bl4 = bl2 = !bl3 && file.isFile();
        assert (file.exists() == bl3 || bl2);
        boolean bl5 = bl3 || bl2;
        boolean bl6 = bl5 && !bl3 && this.canExecute(file);
        boolean bl7 = false;
        Instant instant = bl5 ? this.lastModifiedInstant(file) : Instant.EPOCH;
        long l2 = 0L;
        return new FS$Attributes(this, file, bl5, bl3, bl6, bl7, bl2, l2, instant, -1L);
    }

    public File normalize(File file) {
        return file;
    }

    public String normalize(String string) {
        return string;
    }

    private static boolean isSymRef(byte[] byArray) {
        if (byArray.length < 9) {
            return false;
        }
        return byArray[0] == 103 && byArray[1] == 105 && byArray[2] == 116 && byArray[3] == 100 && byArray[4] == 105 && byArray[5] == 114 && byArray[6] == 58 && byArray[7] == 32;
    }

    public File getSymRef(File file, File file2) {
        byte[] byArray = IO.readFully(file2);
        if (!FS.isSymRef(byArray)) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidGitdirRef, file2.getAbsolutePath()));
        }
        int n2 = 8;
        int n3 = RawParseUtils.nextLF(byArray, n2);
        while (byArray[n3 - 1] == 10 || byArray[n3 - 1] == 13 && SystemReader.getInstance().isWindows()) {
            --n3;
        }
        if (n3 == n2) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidGitdirRef, file2.getAbsolutePath()));
        }
        String string = RawParseUtils.decode(byArray, n2, n3);
        File file3 = this.resolve(file, string);
        if (file3.isAbsolute()) {
            return file3;
        }
        return new File(file, string).getCanonicalFile();
    }

    public File getCommonDir(File file) {
        String string;
        File file2 = null;
        File file3 = new File(file, "commondir");
        if (file3.isFile() && !(file2 = new File(string = new String(IO.readFully(file3)).trim())).isAbsolute()) {
            file2 = new File(file, string).getCanonicalFile();
        }
        return file2;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

