/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.JGitText;

class FS$GobblerThread
extends Thread {
    private static final int PROCESS_EXIT_TIMEOUT = 5;
    private final Process p;
    private final String desc;
    private final String dir;
    final AtomicBoolean fail = new AtomicBoolean();
    final AtomicReference errorMessage = new AtomicReference();
    final AtomicReference exception = new AtomicReference();

    FS$GobblerThread(Process process, String[] stringArray, File file) {
        this.p = process;
        this.desc = Arrays.toString(stringArray);
        this.dir = Objects.toString(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStream inputStream = this.p.getErrorStream();){
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                stringBuilder.append((char)n2);
            }
        }
        catch (IOException iOException) {
            if (this.waitForProcessCompletion(iOException) && this.p.exitValue() != 0) {
                this.setError(iOException, iOException.getMessage(), this.p.exitValue());
                this.fail.set(true);
            }
        }
        finally {
            if (this.waitForProcessCompletion(null) && stringBuilder.length() > 0) {
                this.setError(null, stringBuilder.toString(), this.p.exitValue());
                if (this.p.exitValue() != 0) {
                    this.fail.set(true);
                }
            }
        }
    }

    private boolean waitForProcessCompletion(IOException iOException) {
        try {
            if (!this.p.waitFor(5L, TimeUnit.SECONDS)) {
                this.setError(iOException, MessageFormat.format(JGitText.get().commandClosedStderrButDidntExit, this.desc, 5), -1);
                this.fail.set(true);
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            this.setError(iOException, MessageFormat.format(JGitText.get().threadInterruptedWhileRunning, this.desc), -1);
            this.fail.set(true);
            return false;
        }
        return true;
    }

    private void setError(IOException iOException, String string, int n2) {
        this.exception.set(iOException);
        this.errorMessage.set(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCommand, this.desc, this.dir, n2, string));
    }
}

