/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.SimpleLruCache;
import org.eclipse.jgit.util.Stats;
import org.eclipse.jgit.util.SystemReader;

public final class FS$FileStoreAttributes {
    private static final Duration UNDEFINED_DURATION = Duration.ofNanos(Long.MAX_VALUE);
    public static final Duration FALLBACK_TIMESTAMP_RESOLUTION = Duration.ofMillis(2000L);
    public static final FS$FileStoreAttributes FALLBACK_FILESTORE_ATTRIBUTES = new FS$FileStoreAttributes(FALLBACK_TIMESTAMP_RESOLUTION);
    private static final long ONE_MICROSECOND = TimeUnit.MICROSECONDS.toNanos(1L);
    private static final long ONE_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long ONE_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long MINIMUM_RESOLUTION_NANOS = ONE_MICROSECOND;
    private static final String JAVA_VERSION_PREFIX = System.getProperty("java.vendor") + '|' + System.getProperty("java.version") + '|';
    private static final Duration FALLBACK_MIN_RACY_INTERVAL = Duration.ofMillis(10L);
    private static final Map attributeCache = new ConcurrentHashMap();
    private static final SimpleLruCache attrCacheByPath = new SimpleLruCache(100, 0.2f);
    private static final AtomicBoolean background = new AtomicBoolean();
    private static final Map locks = new ConcurrentHashMap();
    private static final AtomicInteger threadNumber = new AtomicInteger(1);
    private static final ExecutorService FUTURE_RUNNER = new ThreadPoolExecutor(0, 5, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
        Thread thread = new Thread(runnable, "JGit-FileStoreAttributeReader-" + threadNumber.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    });
    private static final ExecutorService SAVE_RUNNER = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
        Thread thread = new Thread(runnable, "JGit-FileStoreAttributeWriter-" + threadNumber.getAndIncrement());
        thread.setDaemon(false);
        return thread;
    });
    @NonNull
    private final Duration fsTimestampResolution;
    private Duration minimalRacyInterval;

    public static void setBackground(boolean bl2) {
        background.set(bl2);
    }

    public static void configureAttributesPathCache(int n2, float f2) {
        attrCacheByPath.configure(n2, f2);
    }

    public static FS$FileStoreAttributes get(Path path, FS fS) {
        try {
            Path path2;
            path = path.toAbsolutePath();
            Path path3 = path2 = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
            if (path2 == null) {
                return FALLBACK_FILESTORE_ATTRIBUTES;
            }
            FS$FileStoreAttributes fS$FileStoreAttributes = (FS$FileStoreAttributes)attrCacheByPath.get(path2);
            if (fS$FileStoreAttributes != null) {
                return fS$FileStoreAttributes;
            }
            FS$FileStoreAttributes fS$FileStoreAttributes2 = FS$FileStoreAttributes.getFileStoreAttributes(path2, fS);
            if (fS$FileStoreAttributes2 == null) {
                return FALLBACK_FILESTORE_ATTRIBUTES;
            }
            attrCacheByPath.put(path2, fS$FileStoreAttributes2);
            return fS$FileStoreAttributes2;
        }
        catch (SecurityException securityException) {
            return FALLBACK_FILESTORE_ATTRIBUTES;
        }
    }

    private static FS$FileStoreAttributes getFileStoreAttributes(Path path, FS fS) {
        try {
            Optional optional;
            Object object;
            FileStore fileStore;
            if (Files.exists(path, new LinkOption[0])) {
                fileStore = Files.getFileStore(path);
                object = (FS$FileStoreAttributes)attributeCache.get(fileStore);
                if (object != null) {
                    return object;
                }
                if (!Files.isWritable(path)) {
                    FS.access$000().debug("{}: cannot measure timestamp resolution in read-only directory {}", (Object)Thread.currentThread(), (Object)path);
                    return FALLBACK_FILESTORE_ATTRIBUTES;
                }
            } else {
                FS.access$000().debug("{}: cannot measure timestamp resolution of unborn directory {}", (Object)Thread.currentThread(), (Object)path);
                return FALLBACK_FILESTORE_ATTRIBUTES;
            }
            object = CompletableFuture.supplyAsync(() -> {
                Lock lock = locks.computeIfAbsent(fileStore, fileStore -> new ReentrantLock());
                if (!lock.tryLock()) {
                    FS.access$000().debug("{}: couldn't get lock to measure timestamp resolution in {}", (Object)Thread.currentThread(), (Object)path);
                    return Optional.empty();
                }
                Optional<FS$FileStoreAttributes> optional = Optional.empty();
                try {
                    FS$FileStoreAttributes fS$FileStoreAttributes = (FS$FileStoreAttributes)attributeCache.get(fileStore);
                    if (fS$FileStoreAttributes != null) {
                        Optional<FS$FileStoreAttributes> optional2 = Optional.of(fS$FileStoreAttributes);
                        return optional2;
                    }
                    optional = FS$FileStoreAttributes.readFromConfig(fileStore, fS);
                    if (optional.isPresent()) {
                        attributeCache.put(fileStore, optional.get());
                        Optional<FS$FileStoreAttributes> optional3 = optional;
                        return optional3;
                    }
                    Optional optional4 = FS$FileStoreAttributes.measureFsTimestampResolution(fileStore, path);
                    if (optional4.isPresent()) {
                        fS$FileStoreAttributes = new FS$FileStoreAttributes((Duration)optional4.get());
                        attributeCache.put(fileStore, fS$FileStoreAttributes);
                        if (fS$FileStoreAttributes.fsTimestampResolution.toNanos() < 100000000L) {
                            fS$FileStoreAttributes.minimalRacyInterval = FS$FileStoreAttributes.measureMinimalRacyInterval(path, fS);
                        }
                        if (FS.access$000().isDebugEnabled()) {
                            FS.access$000().debug(fS$FileStoreAttributes.toString());
                        }
                        FS$FileStoreAttributes fS$FileStoreAttributes2 = fS$FileStoreAttributes;
                        SAVE_RUNNER.execute(() -> FS$FileStoreAttributes.saveToConfig(fileStore, fS$FileStoreAttributes2, fS));
                    }
                    optional = Optional.of(fS$FileStoreAttributes);
                }
                finally {
                    lock.unlock();
                    locks.remove(fileStore);
                }
                return optional;
            }, FUTURE_RUNNER);
            object = ((CompletableFuture)object).exceptionally(throwable -> {
                FS.access$000().error(throwable.getLocalizedMessage(), throwable);
                return Optional.empty();
            });
            boolean bl2 = background.get();
            Optional optional2 = optional = bl2 ? (Optional)((CompletableFuture)object).get(100L, TimeUnit.MILLISECONDS) : (Optional)((CompletableFuture)object).get();
            if (optional.isPresent()) {
                return (FS$FileStoreAttributes)optional.get();
            }
            if (bl2) {
                return null;
            }
        }
        catch (IOException | CancellationException | ExecutionException exception) {
            FS.access$000().error(exception.getMessage(), (Throwable)exception);
        }
        catch (SecurityException | TimeoutException exception) {
        }
        catch (InterruptedException interruptedException) {
            FS.access$000().error(interruptedException.getMessage(), (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        FS.access$000().debug("{}: use fallback timestamp resolution for directory {}", (Object)Thread.currentThread(), (Object)path);
        return FALLBACK_FILESTORE_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Duration measureMinimalRacyInterval(Path path, FS fS) {
        Object object;
        FS.access$000().debug("{}: start measure minimal racy interval in {}", (Object)Thread.currentThread(), (Object)path);
        int n2 = 0;
        int n3 = 0;
        long l2 = 0L;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Path path2 = path.resolve(".probe-" + UUID.randomUUID());
        Instant instant = Instant.now().plusSeconds(3L);
        try {
            path2.toFile().deleteOnExit();
            Files.createFile(path2, new FileAttribute[0]);
            do {
                ++n2;
                FS$FileStoreAttributes.write(path2, "a");
                object = FileSnapshot.save(path2.toFile(), fS);
                FS$FileStoreAttributes.read(path2);
                FS$FileStoreAttributes.write(path2, "b");
                if (((FileSnapshot)object).isModified(path2.toFile())) continue;
                arrayList.add(((FileSnapshot)object).lastDelta());
                l2 = ((FileSnapshot)object).lastRacyThreshold();
                ++n3;
            } while (Instant.now().compareTo(instant) < 0);
        }
        catch (IOException iOException) {
            FS.access$000().error(iOException.getMessage(), (Throwable)iOException);
            Duration duration = FALLBACK_MIN_RACY_INTERVAL;
            return duration;
        }
        finally {
            FS$FileStoreAttributes.deleteProbe(path2);
        }
        if (n3 > 0) {
            object = new Stats();
            for (Long l3 : arrayList) {
                ((Stats)object).add(l3.longValue());
            }
            FS.access$000().debug("delta [ns] since modification FileSnapshot failed to detect\ncount, failures, racy limit [ns], delta min [ns], delta max [ns], delta avg [ns], delta stddev [ns]\n{}, {}, {}, {}, {}, {}, {}", new Object[]{n2, n3, l2, ((Stats)object).min(), ((Stats)object).max(), ((Stats)object).avg(), ((Stats)object).stddev()});
            return Duration.ofNanos(Double.valueOf(((Stats)object).max()).longValue());
        }
        FS.access$000().debug("{}: no failures when measuring minimal racy interval", (Object)Thread.currentThread());
        return Duration.ZERO;
    }

    private static void write(Path path, String string) {
        Path path2 = path.getParent();
        if (path2 != null) {
            FileUtils.mkdirs(path2.toFile(), true);
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);){
            outputStreamWriter.write(string);
        }
    }

    private static String read(Path path) {
        byte[] byArray = IO.readFully(path.toFile());
        return new String(byArray, 0, byArray.length, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional measureFsTimestampResolution(FileStore fileStore, Path path) {
        if (FS.access$000().isDebugEnabled()) {
            FS.access$000().debug("{}: start measure timestamp resolution {} in {}", new Object[]{Thread.currentThread(), fileStore, path});
        }
        Path path2 = path.resolve(".probe-" + UUID.randomUUID());
        try {
            path2.toFile().deleteOnExit();
            Files.createFile(path2, new FileAttribute[0]);
            Duration duration = FS$FileStoreAttributes.getFsResolution(fileStore, path, path2);
            Duration duration2 = FS$FileStoreAttributes.measureClockResolution();
            duration = duration.plus(duration2);
            if (FS.access$000().isDebugEnabled()) {
                FS.access$000().debug("{}: end measure timestamp resolution {} in {}; got {}", new Object[]{Thread.currentThread(), fileStore, path, duration});
            }
            Optional<Duration> optional = Optional.of(duration);
            return optional;
        }
        catch (SecurityException securityException) {
            FS.access$000().warn(securityException.getLocalizedMessage(), (Throwable)securityException);
        }
        catch (AccessDeniedException accessDeniedException) {
            FS.access$000().warn(accessDeniedException.getLocalizedMessage(), (Throwable)accessDeniedException);
        }
        catch (IOException iOException) {
            FS.access$000().error(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        finally {
            FS$FileStoreAttributes.deleteProbe(path2);
        }
        return Optional.empty();
    }

    private static Duration getFsResolution(FileStore fileStore, Path path, Path path2) {
        Duration duration;
        FileTime fileTime;
        long[] lArray;
        File file = path2.toFile();
        FileTime fileTime2 = Files.getLastModifiedTime(path2, new LinkOption[0]);
        Instant instant = fileTime2.toInstant();
        Duration duration2 = FALLBACK_TIMESTAMP_RESOLUTION;
        long l2 = MINIMUM_RESOLUTION_NANOS;
        long l3 = ONE_SECOND;
        long l4 = TimeUnit.MILLISECONDS.toSeconds(duration2.toMillis());
        long l5 = 0L;
        for (long l6 : lArray = new long[]{ONE_MICROSECOND, ONE_MILLISECOND}) {
            if (l6 >= ONE_MILLISECOND) {
                file.setLastModified(instant.plusNanos(l6).toEpochMilli());
            } else {
                Files.setLastModifiedTime(path2, FileTime.from(instant.plusNanos(l6)));
            }
            fileTime = Files.getLastModifiedTime(path2, new LinkOption[0]);
            if (fileTime.compareTo(fileTime2) > 0) {
                duration = Duration.between(instant, fileTime.toInstant());
                if (duration.isZero() || duration.isNegative() || duration.compareTo(duration2) >= 0) continue;
                l3 = l6;
                l4 = 1L;
                duration2 = duration;
                break;
            }
            l2 = Math.max(l2, l6);
        }
        while (l4 > l5) {
            long l7 = (l4 + l5) / 2L;
            if (l7 == 0L) {
                long l8 = l3 / 10L;
                if (l8 < l2) break;
                l3 = l8;
                l7 = ((l4 *= l3 / l8) + (l5 *= l3 / l8)) / 2L;
            }
            long l9 = l7 * l3;
            if (l3 >= ONE_MILLISECOND) {
                file.setLastModified(instant.plusNanos(l9).toEpochMilli());
            } else {
                Files.setLastModifiedTime(path2, FileTime.from(instant.plusNanos(l9)));
            }
            fileTime = Files.getLastModifiedTime(path2, new LinkOption[0]);
            int n2 = fileTime.compareTo(fileTime2);
            if (n2 > 0) {
                l4 = l7;
                duration = Duration.between(instant, fileTime.toInstant());
                if (duration.isZero() || duration.isNegative()) {
                    FS.access$000().warn(JGitText.get().logInconsistentFiletimeDiff, new Object[]{Thread.currentThread(), fileStore, path, fileTime, fileTime2, duration, duration2});
                    break;
                }
                if (duration.compareTo(duration2) > 0) {
                    FS.access$000().warn(JGitText.get().logLargerFiletimeDiff, new Object[]{Thread.currentThread(), fileStore, path, duration, duration2});
                    break;
                }
                duration2 = duration;
                continue;
            }
            if (n2 < 0) {
                FS.access$000().warn(JGitText.get().logSmallerFiletime, new Object[]{Thread.currentThread(), fileStore, path, fileTime, fileTime2, duration2});
                break;
            }
            l5 = l7 + 1L;
        }
        return duration2;
    }

    private static Duration measureClockResolution() {
        Duration duration = Duration.ZERO;
        for (int i2 = 0; i2 < 10; ++i2) {
            Instant instant;
            Instant instant2 = instant = Instant.now();
            while (instant2.compareTo(instant) <= 0) {
                instant2 = Instant.now();
            }
            Duration duration2 = Duration.between(instant, instant2);
            if (duration2.compareTo(duration) <= 0) continue;
            duration = duration2;
        }
        return duration;
    }

    private static void deleteProbe(Path path) {
        try {
            FileUtils.delete(path.toFile(), 6);
        }
        catch (IOException iOException) {
            FS.access$000().error(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private static Optional readFromConfig(FileStore fileStore, FS fS) {
        StoredConfig storedConfig;
        try {
            storedConfig = SystemReader.getInstance().getUserConfig(fS);
        }
        catch (IOException | ConfigInvalidException exception) {
            FS.access$000().error(JGitText.get().readFileStoreAttributesFailed, (Throwable)exception);
            return Optional.empty();
        }
        String string = FS$FileStoreAttributes.getConfigKey(fileStore);
        Duration duration = Duration.ofNanos(storedConfig.getTimeUnit("filesystem", string, "timestampResolution", UNDEFINED_DURATION.toNanos(), TimeUnit.NANOSECONDS));
        if (UNDEFINED_DURATION.equals(duration)) {
            return Optional.empty();
        }
        Duration duration2 = Duration.ofNanos(storedConfig.getTimeUnit("filesystem", string, "minRacyThreshold", UNDEFINED_DURATION.toNanos(), TimeUnit.NANOSECONDS));
        FS$FileStoreAttributes fS$FileStoreAttributes = new FS$FileStoreAttributes(duration);
        if (!UNDEFINED_DURATION.equals(duration2)) {
            fS$FileStoreAttributes.minimalRacyInterval = duration2;
        }
        return Optional.of(fS$FileStoreAttributes);
    }

    private static void saveToConfig(FileStore fileStore, FS$FileStoreAttributes fS$FileStoreAttributes, FS fS) {
        StoredConfig storedConfig;
        try {
            storedConfig = SystemReader.getInstance().getJGitConfig(fS);
        }
        catch (IOException | ConfigInvalidException exception) {
            FS.access$000().error(JGitText.get().saveFileStoreAttributesFailed, (Throwable)exception);
            return;
        }
        long l2 = fS$FileStoreAttributes.getFsTimestampResolution().toNanos();
        TimeUnit timeUnit = FS$FileStoreAttributes.getUnit(l2);
        long l3 = timeUnit.convert(l2, TimeUnit.NANOSECONDS);
        long l4 = fS$FileStoreAttributes.getMinimalRacyInterval().toNanos();
        TimeUnit timeUnit2 = FS$FileStoreAttributes.getUnit(l4);
        long l5 = timeUnit2.convert(l4, TimeUnit.NANOSECONDS);
        int n2 = 5;
        int n3 = 0;
        boolean bl2 = false;
        String string = FS$FileStoreAttributes.getConfigKey(fileStore);
        while (!bl2 && n3 < 5) {
            try {
                storedConfig.setString("filesystem", string, "timestampResolution", String.format("%d %s", l3, timeUnit.name().toLowerCase()));
                storedConfig.setString("filesystem", string, "minRacyThreshold", String.format("%d %s", l5, timeUnit2.name().toLowerCase()));
                storedConfig.save();
                bl2 = true;
            }
            catch (LockFailedException lockFailedException) {
                try {
                    if (++n3 < 5) {
                        Thread.sleep(100L);
                        FS.access$000().debug("locking {} failed, retries {}/{}", new Object[]{storedConfig, n3, 5});
                        continue;
                    }
                    FS.access$000().warn(MessageFormat.format(JGitText.get().lockFailedRetry, storedConfig, n3));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (IOException iOException) {
                FS.access$000().error(MessageFormat.format(JGitText.get().cannotSaveConfig, storedConfig), (Throwable)iOException);
                break;
            }
        }
    }

    private static String getConfigKey(FileStore fileStore) {
        String string;
        if (SystemReader.getInstance().isWindows()) {
            Object object = null;
            try {
                object = fileStore.getAttribute("volume:vsn");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = object instanceof Integer ? object.toString() : fileStore.name();
        } else {
            string = fileStore.name();
        }
        return JAVA_VERSION_PREFIX + string;
    }

    private static TimeUnit getUnit(long l2) {
        TimeUnit timeUnit = l2 < 200000L ? TimeUnit.NANOSECONDS : (l2 < 200000000L ? TimeUnit.MICROSECONDS : TimeUnit.MILLISECONDS);
        return timeUnit;
    }

    public Duration getMinimalRacyInterval() {
        return this.minimalRacyInterval;
    }

    @NonNull
    public Duration getFsTimestampResolution() {
        return this.fsTimestampResolution;
    }

    public FS$FileStoreAttributes(@NonNull Duration duration) {
        this.fsTimestampResolution = duration;
        this.minimalRacyInterval = Duration.ZERO;
    }

    public String toString() {
        return String.format("FileStoreAttributes[fsTimestampResolution=%,d \u00b5s, minimalRacyInterval=%,d \u00b5s]", this.fsTimestampResolution.toNanos() / 1000L, this.minimalRacyInterval.toNanos() / 1000L);
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    SAVE_RUNNER.shutdownNow();
                    SAVE_RUNNER.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

