/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter$Formatter;
import org.eclipse.jgit.lib.PersonIdent;

public class ChangeIdUtil {
    static final String CHANGE_ID = "Change-Id:";
    private static final Pattern issuePattern = Pattern.compile("^(Bug|Issue)[a-zA-Z0-9-]*:.*$");
    private static final Pattern footerPattern = Pattern.compile("(^[a-zA-Z0-9-]+:(?!//).*$)");
    private static final Pattern changeIdPattern = Pattern.compile("(^Change-Id: *I[a-f0-9]{40}$)");
    private static final Pattern includeInFooterPattern = Pattern.compile("^[ \\[].*$");
    private static final Pattern trailingWhitespace = Pattern.compile("\\s+$");

    static String clean(String string) {
        return string.replaceAll("(?i)(?m)^Signed-off-by:.*$\n?", "").replaceAll("(?m)^#.*$\n?", "").replaceAll("(?m)\n\n\n+", "\\\n").replaceAll("\\n*$", "").replaceAll("(?s)\ndiff --git.*", "").trim();
    }

    public static ObjectId computeChangeId(ObjectId objectId, ObjectId objectId2, PersonIdent personIdent, PersonIdent personIdent2, String string) {
        String string2 = ChangeIdUtil.clean(string);
        if (string2.length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tree ");
        stringBuilder.append(ObjectId.toString(objectId));
        stringBuilder.append("\n");
        if (objectId2 != null) {
            stringBuilder.append("parent ");
            stringBuilder.append(ObjectId.toString(objectId2));
            stringBuilder.append("\n");
        }
        stringBuilder.append("author ");
        stringBuilder.append(personIdent.toExternalString());
        stringBuilder.append("\n");
        stringBuilder.append("committer ");
        stringBuilder.append(personIdent2.toExternalString());
        stringBuilder.append("\n\n");
        stringBuilder.append(string2);
        try (ObjectInserter$Formatter objectInserter$Formatter = new ObjectInserter$Formatter();){
            ObjectId objectId3 = objectInserter$Formatter.idFor(1, Constants.encode(stringBuilder.toString()));
            return objectId3;
        }
    }

    public static String insertId(String string, ObjectId objectId) {
        return ChangeIdUtil.insertId(string, objectId, false);
    }

    public static String insertId(String string, ObjectId objectId, boolean bl2) {
        int n2;
        int n3;
        int n4 = ChangeIdUtil.indexOfChangeId(string, "\n");
        if (n4 > 0) {
            if (!bl2) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string.substring(0, n4));
            stringBuilder.append(CHANGE_ID);
            stringBuilder.append(" I");
            stringBuilder.append(ObjectId.toString(objectId));
            int n5 = string.indexOf(10, n4);
            if (n5 > 0) {
                stringBuilder.append(string.substring(n5));
            }
            return stringBuilder.toString();
        }
        String[] stringArray = string.split("\n");
        int n6 = n3 = ChangeIdUtil.indexOfFirstFooterLine(stringArray);
        for (int i2 = n3; i2 < stringArray.length && issuePattern.matcher(stringArray[i2]).matches(); ++i2) {
            n6 = i2 + 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < n6; ++n2) {
            stringBuilder.append(stringArray[n2]);
            stringBuilder.append("\n");
        }
        if (n6 == stringArray.length && n6 == n3) {
            stringBuilder.append("\n");
        }
        stringBuilder.append(CHANGE_ID);
        stringBuilder.append(" I");
        stringBuilder.append(ObjectId.toString(objectId));
        stringBuilder.append("\n");
        while (n2 < stringArray.length) {
            stringBuilder.append(stringArray[n2]);
            stringBuilder.append("\n");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int indexOfChangeId(String string, String string2) {
        int n2;
        String[] stringArray = string.split(string2);
        if (stringArray.length == 0) {
            return -1;
        }
        int n3 = 0;
        boolean bl2 = false;
        for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
            if (!bl2 && ChangeIdUtil.isEmptyLine(stringArray[n2])) continue;
            bl2 = true;
            if (changeIdPattern.matcher(ChangeIdUtil.trimRight(stringArray[n2])).matches()) {
                n3 = n2;
                break;
            }
            if (!ChangeIdUtil.isEmptyLine(stringArray[n2]) && n2 != 0) continue;
            return -1;
        }
        n2 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += stringArray[i2].length() + string2.length();
        }
        return n2 + stringArray[n3].indexOf(CHANGE_ID);
    }

    private static boolean isEmptyLine(String string) {
        return string.trim().length() == 0;
    }

    private static String trimRight(String string) {
        return trailingWhitespace.matcher(string).replaceAll("");
    }

    public static int indexOfFirstFooterLine(String[] stringArray) {
        int n2 = stringArray.length;
        for (int i2 = stringArray.length - 1; i2 > 1; --i2) {
            if (footerPattern.matcher(stringArray[i2]).matches()) {
                n2 = i2;
                continue;
            }
            if (n2 != stringArray.length && stringArray[i2].length() == 0) break;
            if (n2 != stringArray.length && includeInFooterPattern.matcher(stringArray[i2]).matches()) {
                n2 = i2 + 1;
                continue;
            }
            n2 = stringArray.length;
            break;
        }
        return n2;
    }
}

