/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jgit.util.BlockList$MyIterator;

public class BlockList
extends AbstractList {
    private static final int BLOCK_BITS = 10;
    static final int BLOCK_SIZE = 1024;
    private static final int BLOCK_MASK = 1023;
    Object[][] directory;
    int size;
    private int tailDirIdx;
    private int tailBlkIdx;
    private Object[] tailBlock;

    public BlockList() {
        this.directory = BlockList.newDirectory(256);
        this.directory[0] = BlockList.newBlock();
        this.tailBlock = this.directory[0];
    }

    public BlockList(int n2) {
        int n3 = BlockList.toDirectoryIndex(n2);
        if ((n2 & 0x3FF) != 0 || n3 == 0) {
            ++n3;
        }
        this.directory = BlockList.newDirectory(n3);
        this.directory[0] = BlockList.newBlock();
        this.tailBlock = this.directory[0];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        for (Object[] objectArray : this.directory) {
            if (objectArray == null) continue;
            Arrays.fill(objectArray, null);
        }
        this.size = 0;
        this.tailDirIdx = 0;
        this.tailBlkIdx = 0;
        this.tailBlock = this.directory[0];
    }

    @Override
    public Object get(int n2) {
        if (n2 < 0 || this.size <= n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.directory[BlockList.toDirectoryIndex(n2)][BlockList.toBlockIndex(n2)];
    }

    @Override
    public Object set(int n2, Object object) {
        if (n2 < 0 || this.size <= n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        Object[] objectArray = this.directory[BlockList.toDirectoryIndex(n2)];
        int n3 = BlockList.toBlockIndex(n2);
        Object object2 = objectArray[n3];
        objectArray[n3] = object;
        return object2;
    }

    public void addAll(BlockList blockList) {
        if (blockList.size == 0) {
            return;
        }
        for (int i2 = 0; i2 < blockList.tailDirIdx; ++i2) {
            this.addAll(blockList.directory[i2], 0, 1024);
        }
        if (blockList.tailBlkIdx != 0) {
            this.addAll(blockList.tailBlock, 0, blockList.tailBlkIdx);
        }
    }

    public void addAll(Object[] objectArray, int n2, int n3) {
        while (0 < n3) {
            int n4 = this.tailBlkIdx;
            int n5 = Math.min(n3, 1024 - n4);
            if (n5 == 0) {
                this.add(objectArray[n2++]);
                --n3;
                continue;
            }
            System.arraycopy(objectArray, n2, this.tailBlock, n4, n5);
            this.tailBlkIdx += n5;
            this.size += n5;
            n2 += n5;
            n3 -= n5;
        }
    }

    @Override
    public boolean add(Object object) {
        Object[] objectArray;
        int n2 = this.tailBlkIdx;
        if (n2 < 1024) {
            this.tailBlock[n2] = object;
            this.tailBlkIdx = n2 + 1;
            ++this.size;
            return true;
        }
        if (++this.tailDirIdx == this.directory.length) {
            objectArray = BlockList.newDirectory(this.directory.length << 1);
            System.arraycopy(this.directory, 0, objectArray, 0, this.directory.length);
            this.directory = objectArray;
        }
        if ((objectArray = this.directory[this.tailDirIdx]) == null) {
            objectArray = BlockList.newBlock();
            this.directory[this.tailDirIdx] = objectArray;
        }
        objectArray[0] = object;
        this.tailBlock = objectArray;
        this.tailBlkIdx = 1;
        ++this.size;
        return true;
    }

    @Override
    public void add(int n2, Object object) {
        if (n2 == this.size) {
            this.add(object);
        } else {
            if (n2 < 0 || this.size < n2) {
                throw new IndexOutOfBoundsException(String.valueOf(n2));
            }
            this.add((Object)null);
            for (int i2 = this.size - 2; n2 <= i2; --i2) {
                this.set(i2 + 1, this.get(i2));
            }
            this.set(n2, object);
        }
    }

    @Override
    public Object remove(int n2) {
        if (n2 == this.size - 1) {
            Object[] objectArray = this.directory[BlockList.toDirectoryIndex(n2)];
            int n3 = BlockList.toBlockIndex(n2);
            Object object = objectArray[n3];
            objectArray[n3] = null;
            --this.size;
            if (0 < this.tailBlkIdx) {
                --this.tailBlkIdx;
            } else {
                this.resetTailBlock();
            }
            return object;
        }
        if (n2 < 0 || this.size <= n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        Object object = this.get(n2);
        while (n2 < this.size - 1) {
            this.set(n2, this.get(n2 + 1));
            ++n2;
        }
        this.set(this.size - 1, (Object)null);
        --this.size;
        this.resetTailBlock();
        return object;
    }

    private void resetTailBlock() {
        this.tailDirIdx = BlockList.toDirectoryIndex(this.size);
        this.tailBlkIdx = BlockList.toBlockIndex(this.size);
        this.tailBlock = this.directory[this.tailDirIdx];
    }

    @Override
    public Iterator iterator() {
        return new BlockList$MyIterator(this, null);
    }

    static final int toDirectoryIndex(int n2) {
        return n2 >>> 10;
    }

    static final int toBlockIndex(int n2) {
        return n2 & 0x3FF;
    }

    private static Object[][] newDirectory(int n2) {
        return new Object[n2][];
    }

    private static Object[] newBlock() {
        return new Object[1024];
    }
}

