/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;

public final class Base85 {
    private static final byte[] ENCODE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~".getBytes(StandardCharsets.US_ASCII);
    private static final int[] DECODE = new int[256];

    private Base85() {
    }

    public static int encodedLength(int n2) {
        return (n2 + 3) / 4 * 5;
    }

    public static byte[] encode(byte[] byArray) {
        return Base85.encode(byArray, 0, byArray.length);
    }

    public static byte[] encode(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[Base85.encodedLength(n3)];
        int n4 = n2 + n3;
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            long l2 = (long)(byArray[n5++] & 0xFF) << 24;
            if (n5 < n4) {
                l2 |= (long)((byArray[n5++] & 0xFF) << 16);
                if (n5 < n4) {
                    l2 |= (long)((byArray[n5++] & 0xFF) << 8);
                    if (n5 < n4) {
                        l2 |= (long)(byArray[n5++] & 0xFF);
                    }
                }
            }
            for (int i2 = 4; i2 >= 0; --i2) {
                byArray2[n6 + i2] = ENCODE[(int)(l2 % 85L)];
                l2 /= 85L;
            }
            n6 += 5;
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray, int n2) {
        return Base85.decode(byArray, 0, byArray.length, n2);
    }

    public static byte[] decode(byte[] byArray, int n2, int n3, int n4) {
        if (n3 % 5 != 0) {
            throw new IllegalArgumentException(JGitText.get().base85length);
        }
        byte[] byArray2 = new byte[n4];
        int n5 = n2 + n3;
        int n6 = n2;
        int n7 = 0;
        while (n6 < n5 && n7 < n4) {
            long l2 = 0L;
            for (int i2 = 4; i2 >= 0; --i2) {
                int n8;
                if ((n8 = DECODE[byArray[n6++] & 0xFF]) < 0) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85invalidChar, Integer.toHexString(byArray[n6 - 1] & 0xFF)));
                }
                l2 = l2 * 85L + (long)n8;
            }
            if (l2 > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85overflow, Long.toHexString(l2)));
            }
            byArray2[n7++] = (byte)(l2 >>> 24);
            if (n7 >= n4) continue;
            byArray2[n7++] = (byte)(l2 >>> 16);
            if (n7 >= n4) continue;
            byArray2[n7++] = (byte)(l2 >>> 8);
            if (n7 >= n4) continue;
            byArray2[n7++] = (byte)l2;
        }
        if (n6 < n5) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85tooLong, n4));
        }
        if (n7 < n4) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85tooShort, n4));
        }
        return byArray2;
    }

    static {
        Arrays.fill(DECODE, -1);
        for (int i2 = 0; i2 < ENCODE.length; ++i2) {
            Base85.DECODE[Base85.ENCODE[i2]] = i2;
        }
    }
}

