/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;

public class Base64 {
    private static final byte EQUALS_SIGN = 61;
    private static final byte EQUALS_SIGN_DEC = -1;
    private static final byte WHITE_SPACE_DEC = -2;
    private static final byte INVALID_DEC = -3;
    private static final byte[] ENC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DEC = new byte[128];

    private Base64() {
    }

    private static void encode3to4(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = 0;
        switch (n3) {
            case 3: {
                n5 |= byArray[n2 + 2] << 24 >>> 24;
            }
            case 2: {
                n5 |= byArray[n2 + 1] << 24 >>> 16;
            }
            case 1: {
                n5 |= byArray[n2] << 24 >>> 8;
            }
        }
        switch (n3) {
            case 3: {
                byArray2[n4] = ENC[n5 >>> 18];
                byArray2[n4 + 1] = ENC[n5 >>> 12 & 0x3F];
                byArray2[n4 + 2] = ENC[n5 >>> 6 & 0x3F];
                byArray2[n4 + 3] = ENC[n5 & 0x3F];
                break;
            }
            case 2: {
                byArray2[n4] = ENC[n5 >>> 18];
                byArray2[n4 + 1] = ENC[n5 >>> 12 & 0x3F];
                byArray2[n4 + 2] = ENC[n5 >>> 6 & 0x3F];
                byArray2[n4 + 3] = 61;
                break;
            }
            case 1: {
                byArray2[n4] = ENC[n5 >>> 18];
                byArray2[n4 + 1] = ENC[n5 >>> 12 & 0x3F];
                byArray2[n4 + 2] = 61;
                byArray2[n4 + 3] = 61;
            }
        }
    }

    public static String encodeBytes(byte[] byArray) {
        return Base64.encodeBytes(byArray, 0, byArray.length);
    }

    public static String encodeBytes(byte[] byArray, int n2, int n3) {
        int n4 = n3 * 4 / 3;
        byte[] byArray2 = new byte[n4 + (n3 % 3 > 0 ? 4 : 0)];
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 - 2;
        while (n5 < n7) {
            Base64.encode3to4(byArray, n5 + n2, 3, byArray2, n6);
            n5 += 3;
            n6 += 4;
        }
        if (n5 < n3) {
            Base64.encode3to4(byArray, n5 + n2, n3 - n5, byArray2, n6);
            n6 += 4;
        }
        return new String(byArray2, 0, n6, StandardCharsets.UTF_8);
    }

    private static int decode4to3(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (byArray[n2 + 2] == 61) {
            int n4 = (DEC[byArray[n2]] & 0xFF) << 18 | (DEC[byArray[n2 + 1]] & 0xFF) << 12;
            byArray2[n3] = (byte)(n4 >>> 16);
            return 1;
        }
        if (byArray[n2 + 3] == 61) {
            int n5 = (DEC[byArray[n2]] & 0xFF) << 18 | (DEC[byArray[n2 + 1]] & 0xFF) << 12 | (DEC[byArray[n2 + 2]] & 0xFF) << 6;
            byArray2[n3] = (byte)(n5 >>> 16);
            byArray2[n3 + 1] = (byte)(n5 >>> 8);
            return 2;
        }
        int n6 = (DEC[byArray[n2]] & 0xFF) << 18 | (DEC[byArray[n2 + 1]] & 0xFF) << 12 | (DEC[byArray[n2 + 2]] & 0xFF) << 6 | DEC[byArray[n2 + 3]] & 0xFF;
        byArray2[n3] = (byte)(n6 >> 16);
        byArray2[n3 + 1] = (byte)(n6 >> 8);
        byArray2[n3 + 2] = (byte)n6;
        return 3;
    }

    public static byte[] decode(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3 * 3 / 4];
        int n4 = 0;
        byte[] byArray3 = new byte[4];
        int n5 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byte by = (byte)(byArray[i2] & 0x7F);
            byte by2 = DEC[by];
            if (-1 <= by2) {
                byArray3[n5++] = by;
                if (n5 <= 3) continue;
                n4 += Base64.decode4to3(byArray3, 0, byArray2, n4);
                n5 = 0;
                if (by != 61) continue;
                break;
            }
            if (by2 == -2) continue;
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badBase64InputCharacterAt, i2, byArray[i2] & 0xFF));
        }
        if (byArray2.length == n4) {
            return byArray2;
        }
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray4, 0, n4);
        return byArray4;
    }

    public static byte[] decode(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        return Base64.decode(byArray, 0, byArray.length);
    }

    static {
        Arrays.fill(DEC, (byte)-3);
        for (int i2 = 0; i2 < 64; ++i2) {
            Base64.DEC[Base64.ENC[i2]] = (byte)i2;
        }
        Base64.DEC[61] = -1;
        Base64.DEC[9] = -2;
        Base64.DEC[10] = -2;
        Base64.DEC[13] = -2;
        Base64.DEC[32] = -2;
    }
}

