/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeFilterMarker {
    private final TreeFilter[] filters;

    public TreeFilterMarker(TreeFilter[] treeFilterArray) {
        if (treeFilterArray.length > 32) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().treeFilterMarkerTooManyFilters, 32, treeFilterArray.length));
        }
        this.filters = new TreeFilter[treeFilterArray.length];
        System.arraycopy(treeFilterArray, 0, this.filters, 0, treeFilterArray.length);
    }

    public int getMarks(TreeWalk treeWalk) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.filters.length; ++i2) {
            TreeFilter treeFilter = this.filters[i2];
            if (treeFilter == null) continue;
            try {
                boolean bl2 = treeFilter.include(treeWalk);
                if (!bl2) continue;
                n2 |= 1 << i2;
                continue;
            }
            catch (StopWalkException stopWalkException) {
                this.filters[i2] = null;
            }
        }
        return n2;
    }
}

