/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class SkipWorkTreeFilter
extends TreeFilter {
    private final int treeIdx;

    public SkipWorkTreeFilter(int n2) {
        this.treeIdx = n2;
    }

    @Override
    public boolean include(TreeWalk treeWalk) {
        DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(this.treeIdx, DirCacheIterator.class);
        if (dirCacheIterator == null) {
            return true;
        }
        DirCacheEntry dirCacheEntry = dirCacheIterator.getDirCacheEntry();
        return dirCacheEntry == null || !dirCacheEntry.isSkipWorkTree();
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "SkipWorkTree(" + this.treeIdx + ")";
    }
}

