/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathSuffixFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathSuffixFilter create(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathSuffixFilter(string);
    }

    private PathSuffixFilter(String string) {
        this.pathStr = string;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public boolean include(TreeWalk treeWalk) {
        if (treeWalk.isSubtree()) {
            return true;
        }
        return treeWalk.isPathSuffix(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public int matchFilter(TreeWalk treeWalk) {
        if (treeWalk.isSubtree()) {
            return -1;
        }
        return super.matchFilter(treeWalk);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }
}

