/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.util.Collection;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup$Group;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup$Single;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilterGroup {
    public static TreeFilter createFromStrings(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] pathFilterArray = new PathFilter[collection.size()];
        int n2 = 0;
        for (String string : collection) {
            pathFilterArray[n2++] = PathFilter.create(string);
        }
        return PathFilterGroup.create(pathFilterArray);
    }

    public static TreeFilter createFromStrings(String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        int n2 = stringArray.length;
        PathFilter[] pathFilterArray = new PathFilter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pathFilterArray[i2] = PathFilter.create(stringArray[i2]);
        }
        return PathFilterGroup.create(pathFilterArray);
    }

    public static TreeFilter create(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] pathFilterArray = new PathFilter[collection.size()];
        collection.toArray(pathFilterArray);
        return PathFilterGroup.create(pathFilterArray);
    }

    private static TreeFilter create(PathFilter[] pathFilterArray) {
        if (pathFilterArray.length == 1) {
            return new PathFilterGroup$Single(pathFilterArray[0]);
        }
        return new PathFilterGroup$Group(pathFilterArray, null);
    }
}

