/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.ByteArraySet;
import org.eclipse.jgit.treewalk.filter.ByteArraySet$Hasher;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.RawParseUtils;

class PathFilterGroup$Group
extends TreeFilter {
    private ByteArraySet fullpaths;
    private ByteArraySet prefixes;
    private byte[] max;

    private PathFilterGroup$Group(PathFilter[] pathFilterArray) {
        this.fullpaths = new ByteArraySet(pathFilterArray.length);
        this.prefixes = new ByteArraySet(pathFilterArray.length / 5);
        this.max = pathFilterArray[0].pathRaw;
        ByteArraySet$Hasher byteArraySet$Hasher = new ByteArraySet$Hasher(null, 0);
        PathFilter[] objectArray = pathFilterArray;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PathFilter pathFilter = objectArray[i2];
            byteArraySet$Hasher.init(pathFilter.pathRaw, pathFilter.pathRaw.length);
            while (byteArraySet$Hasher.hasNext()) {
                int n3 = byteArraySet$Hasher.nextHash();
                if (!byteArraySet$Hasher.hasNext()) continue;
                this.prefixes.addIfAbsent(pathFilter.pathRaw, byteArraySet$Hasher.length(), n3);
            }
            this.fullpaths.addIfAbsent(pathFilter.pathRaw, pathFilter.pathRaw.length, byteArraySet$Hasher.getHash());
            if (PathFilterGroup$Group.compare(this.max, pathFilter.pathRaw) >= 0) continue;
            this.max = pathFilter.pathRaw;
        }
        byte[] byArray = new byte[this.max.length + 1];
        for (n2 = 0; n2 < this.max.length; ++n2) {
            byArray[n2] = (this.max[n2] & 0xFF) < 47 ? 47 : this.max[n2];
        }
        byArray[byArray.length - 1] = 47;
        this.max = byArray;
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length && i2 < byArray2.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            int n3 = byArray2[i2] & 0xFF;
            int n4 = n2 - n3;
            if (n4 == 0) continue;
            return n4;
        }
        return byArray.length - byArray2.length;
    }

    @Override
    public boolean include(TreeWalk treeWalk) {
        int n2;
        byte[] byArray = treeWalk.getRawPath();
        ByteArraySet$Hasher byteArraySet$Hasher = new ByteArraySet$Hasher(byArray, treeWalk.getPathLength());
        while (byteArraySet$Hasher.hasNext()) {
            n2 = byteArraySet$Hasher.nextHash();
            if (this.fullpaths.contains(byArray, byteArraySet$Hasher.length(), n2)) {
                return true;
            }
            if (byteArraySet$Hasher.hasNext() || !treeWalk.isSubtree() || !this.prefixes.contains(byArray, byteArraySet$Hasher.length(), n2)) continue;
            return true;
        }
        n2 = treeWalk.isPathPrefix(this.max, this.max.length);
        if (n2 > 0) {
            throw StopWalkException.INSTANCE;
        }
        return false;
    }

    @Override
    public boolean shouldBeRecursive() {
        return !this.prefixes.isEmpty();
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FAST(");
        boolean bl2 = true;
        for (byte[] byArray : this.fullpaths.toArray()) {
            if (!bl2) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append(RawParseUtils.decode(byArray));
            bl2 = false;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

