/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathFilter create(String string) {
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathFilter(string);
    }

    private PathFilter(String string) {
        this.pathStr = string;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    public String getPath() {
        return this.pathStr;
    }

    @Override
    public boolean include(TreeWalk treeWalk) {
        return this.matchFilter(treeWalk) <= 0;
    }

    @Override
    public int matchFilter(TreeWalk treeWalk) {
        return treeWalk.isPathMatch(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public boolean shouldBeRecursive() {
        for (byte by : this.pathRaw) {
            if (by != 47) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "PATH(\"" + this.pathStr + "\")";
    }

    public boolean isDone(TreeWalk treeWalk) {
        return this.pathRaw.length == treeWalk.getPathLength();
    }
}

