/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public final class InterIndexDiffFilter
extends TreeFilter {
    private static final int baseTree = 0;
    public static final TreeFilter INSTANCE = new InterIndexDiffFilter();

    @Override
    public boolean include(TreeWalk treeWalk) {
        int n2 = treeWalk.getTreeCount();
        if (n2 == 1) {
            return true;
        }
        int n3 = treeWalk.getRawMode(0);
        for (int i2 = 1; i2 < n2; ++i2) {
            DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
            DirCacheIterator dirCacheIterator2 = (DirCacheIterator)treeWalk.getTree(i2, DirCacheIterator.class);
            if (dirCacheIterator != null && dirCacheIterator2 != null) {
                DirCacheEntry dirCacheEntry = dirCacheIterator.getDirCacheEntry();
                DirCacheEntry dirCacheEntry2 = dirCacheIterator2.getDirCacheEntry();
                if (dirCacheEntry != null && dirCacheEntry2 != null) {
                    if (dirCacheEntry.isAssumeValid() != dirCacheEntry2.isAssumeValid()) {
                        return true;
                    }
                    if (dirCacheEntry.isAssumeValid()) {
                        return false;
                    }
                }
            }
            if (treeWalk.getRawMode(i2) == n3 && treeWalk.idEqual(i2, 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "INTERINDEX_DIFF";
    }
}

