/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class IndexDiffFilter
extends TreeFilter {
    private final int dirCache;
    private final int workingTree;
    private final boolean honorIgnores;
    private final Set ignoredPaths = new HashSet();
    private final LinkedList untrackedParentFolders = new LinkedList();
    private final LinkedList untrackedFolders = new LinkedList();

    public IndexDiffFilter(int n2, int n3) {
        this(n2, n3, true);
    }

    public IndexDiffFilter(int n2, int n3, boolean bl2) {
        this.dirCache = n2;
        this.workingTree = n3;
        this.honorIgnores = bl2;
    }

    @Override
    public boolean include(TreeWalk treeWalk) {
        int n2;
        DirCacheEntry dirCacheEntry;
        int n3 = treeWalk.getTreeCount();
        int n4 = treeWalk.getRawMode(this.workingTree);
        WorkingTreeIterator workingTreeIterator = this.workingTree(treeWalk);
        String string = treeWalk.getPathString();
        DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(this.dirCache, DirCacheIterator.class);
        if (dirCacheIterator != null && (dirCacheEntry = dirCacheIterator.getDirCacheEntry()) != null) {
            if (dirCacheEntry.isAssumeValid()) {
                return false;
            }
            if (dirCacheEntry.getStage() != 0) {
                return true;
            }
        }
        if (!treeWalk.isPostOrderTraversal()) {
            if (!(!FileMode.TREE.equals(n4) || this.honorIgnores && workingTreeIterator.isEntryIgnored())) {
                this.copyUntrackedFolders(string);
                this.untrackedParentFolders.addFirst(string);
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = treeWalk.getRawMode(i2);
                if (i2 == this.workingTree || n2 == 0 || !FileMode.TREE.equals(n2)) continue;
                this.untrackedParentFolders.clear();
                break;
            }
        }
        if (n4 == 0) {
            return true;
        }
        int n5 = treeWalk.getRawMode(this.dirCache);
        if (n5 == 0) {
            if (this.honorIgnores && workingTreeIterator.isEntryIgnored()) {
                this.ignoredPaths.add(workingTreeIterator.getEntryPathString());
                for (n2 = 0; n2 < n3 && (n2 == this.dirCache || n2 == this.workingTree || treeWalk.getRawMode(n2) == 0); ++n2) {
                }
                return n2 != n3;
            }
            return true;
        }
        if (treeWalk.isSubtree()) {
            return true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == this.dirCache || n2 == this.workingTree || treeWalk.getRawMode(n2) == n5 && treeWalk.idEqual(n2, this.dirCache)) continue;
            return true;
        }
        return workingTreeIterator.isModified(dirCacheIterator == null ? null : dirCacheIterator.getDirCacheEntry(), true, treeWalk.getObjectReader());
    }

    private void copyUntrackedFolders(String string) {
        String string2 = null;
        while (!this.untrackedParentFolders.isEmpty() && !string.startsWith((String)this.untrackedParentFolders.getFirst() + '/')) {
            string2 = (String)this.untrackedParentFolders.removeFirst();
        }
        if (string2 != null) {
            while (!this.untrackedFolders.isEmpty() && ((String)this.untrackedFolders.getLast()).startsWith(string2 + '/')) {
                this.untrackedFolders.removeLast();
            }
            this.untrackedFolders.addLast(string2);
        }
    }

    private WorkingTreeIterator workingTree(TreeWalk treeWalk) {
        return (WorkingTreeIterator)treeWalk.getTree(this.workingTree, WorkingTreeIterator.class);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "INDEX_DIFF_FILTER";
    }

    public Set getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public List getUntrackedFolders() {
        LinkedList<String> linkedList = new LinkedList<String>(this.untrackedFolders);
        if (!this.untrackedParentFolders.isEmpty()) {
            String string = (String)this.untrackedParentFolders.getLast();
            while (!linkedList.isEmpty() && ((String)linkedList.getLast()).startsWith(string)) {
                linkedList.removeLast();
            }
            linkedList.addLast(string);
        }
        return linkedList;
    }
}

