/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.treewalk.filter.ByteArraySet$Hasher;
import org.eclipse.jgit.util.RawParseUtils;

class ByteArraySet {
    private int size;
    private int grow;
    private int mask;
    private byte[][] table;
    private ByteArraySet$Hasher hasher = new ByteArraySet$Hasher(null, 0);

    ByteArraySet(int n2) {
        this.initTable(1 << Integer.highestOneBit(n2 * 2 - 1));
    }

    private byte[] get(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        int n4 = this.mask;
        int n5 = n3 & n4;
        byte[][] byArray3 = this.table;
        while ((byArray2 = byArray3[n5]) != null) {
            if (ByteArraySet.equals(byArray2, byArray, n2)) {
                return byArray2;
            }
            n5 = n5 + 1 & n4;
        }
        return null;
    }

    private static boolean equals(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray.length != n2 || byArray2.length < n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    boolean contains(byte[] byArray, int n2, int n3) {
        return this.get(byArray, n2, n3) != null;
    }

    byte[] addIfAbsent(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        int n4 = this.mask;
        int n5 = n3 & n4;
        byte[][] byArray3 = this.table;
        while ((byArray2 = byArray3[n5]) != null) {
            if (ByteArraySet.equals(byArray2, byArray, n2)) {
                return byArray2;
            }
            n5 = n5 + 1 & n4;
        }
        byte[] byArray4 = ByteArraySet.copyIfNotSameSize(byArray, n2);
        if (++this.size == this.grow) {
            this.grow();
            this.insert(byArray4, n3);
        } else {
            byArray3[n5] = byArray4;
        }
        return byArray4;
    }

    private static byte[] copyIfNotSameSize(byte[] byArray, int n2) {
        if (byArray.length == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private void insert(byte[] byArray, int n2) {
        int n3 = this.mask;
        int n4 = n2 & n3;
        byte[][] byArray2 = this.table;
        while (byArray2[n4] != null) {
            n4 = n4 + 1 & n3;
        }
        byArray2[n4] = byArray;
    }

    private void grow() {
        byte[][] byArray = this.table;
        int n2 = this.table.length;
        this.initTable(n2 << 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray2 = byArray[i2];
            if (byArray2 == null) continue;
            this.hasher.init(byArray2, byArray2.length);
            this.insert(byArray2, this.hasher.hash());
        }
    }

    private void initTable(int n2) {
        if (n2 < 2) {
            n2 = 2;
        }
        this.grow = n2 >> 1;
        this.mask = n2 - 1;
        this.table = new byte[n2][];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (byte[] byArray : this.table) {
            if (byArray == null) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(" , ");
            }
            stringBuilder.append('\"');
            stringBuilder.append(RawParseUtils.decode(byArray));
            stringBuilder.append('\"');
            stringBuilder.append('(');
            stringBuilder.append(this.chainlength(byArray));
            stringBuilder.append(')');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private int chainlength(byte[] byArray) {
        byte[] byArray2;
        ByteArraySet$Hasher byteArraySet$Hasher = new ByteArraySet$Hasher(byArray, byArray.length);
        int n2 = byteArraySet$Hasher.hash();
        int n3 = this.mask;
        int n4 = n2 & n3;
        byte[][] byArray3 = this.table;
        int n5 = 0;
        while ((byArray2 = byArray3[n4]) != null) {
            if (ByteArraySet.equals(byArray2, byArray, byArray.length)) {
                return n5;
            }
            n4 = n4 + 1 & n3;
            ++n5;
        }
        return -1;
    }

    byte[][] toArray() {
        byte[][] byArrayArray = new byte[this.size][];
        int n2 = 0;
        for (byte[] byArray : this.table) {
            if (byArray == null) continue;
            byArrayArray[n2++] = byArray;
        }
        return byArrayArray;
    }
}

