/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Config$SectionParser;
import org.eclipse.jgit.lib.CoreConfig$AutoCRLF;
import org.eclipse.jgit.lib.CoreConfig$CheckStat;
import org.eclipse.jgit.lib.CoreConfig$EOL;
import org.eclipse.jgit.lib.CoreConfig$HideDotFiles;
import org.eclipse.jgit.lib.CoreConfig$SymLinks;

public class WorkingTreeOptions {
    public static final Config$SectionParser KEY = WorkingTreeOptions::new;
    private final boolean fileMode;
    private final CoreConfig$AutoCRLF autoCRLF;
    private final CoreConfig$EOL eol;
    private final CoreConfig$CheckStat checkStat;
    private final CoreConfig$SymLinks symlinks;
    private final CoreConfig$HideDotFiles hideDotFiles;
    private final boolean dirNoGitLinks;

    private WorkingTreeOptions(Config config) {
        this.fileMode = config.getBoolean("core", "filemode", true);
        this.autoCRLF = (CoreConfig$AutoCRLF)config.getEnum("core", null, "autocrlf", CoreConfig$AutoCRLF.FALSE);
        this.eol = (CoreConfig$EOL)config.getEnum("core", null, "eol", CoreConfig$EOL.NATIVE);
        this.checkStat = (CoreConfig$CheckStat)config.getEnum("core", null, "checkstat", CoreConfig$CheckStat.DEFAULT);
        this.symlinks = (CoreConfig$SymLinks)config.getEnum("core", null, "symlinks", CoreConfig$SymLinks.TRUE);
        this.hideDotFiles = (CoreConfig$HideDotFiles)config.getEnum("core", null, "hidedotfiles", CoreConfig$HideDotFiles.DOTGITONLY);
        this.dirNoGitLinks = config.getBoolean("core", null, "dirNoGitLinks", false);
    }

    public boolean isFileMode() {
        return this.fileMode;
    }

    public CoreConfig$AutoCRLF getAutoCRLF() {
        return this.autoCRLF;
    }

    public CoreConfig$EOL getEOL() {
        return this.eol;
    }

    public CoreConfig$CheckStat getCheckStat() {
        return this.checkStat;
    }

    public CoreConfig$SymLinks getSymLinks() {
        return this.symlinks;
    }

    public CoreConfig$HideDotFiles getHideDotFiles() {
        return this.hideDotFiles;
    }

    public boolean isDirNoGitLinks() {
        return this.dirNoGitLinks;
    }
}

